@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Contains information about the auto-storage account associated with a Batch account.
 * @property authenticationMode The authentication mode which the Batch service will use to manage the auto-storage account.
 * @property lastKeySync The UTC time at which storage keys were last synchronized with the Batch account.
 * @property nodeIdentityReference The identity referenced here must be assigned to pools which have compute nodes that need access to auto-storage.
 * @property storageAccountId The resource ID of the storage account to be used for auto-storage account.
 */
public data class AutoStoragePropertiesResponse(
    public val authenticationMode: String? = null,
    public val lastKeySync: String,
    public val nodeIdentityReference: ComputeNodeIdentityReferenceResponse? = null,
    public val storageAccountId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.batch.outputs.AutoStoragePropertiesResponse): AutoStoragePropertiesResponse = AutoStoragePropertiesResponse(
            authenticationMode = javaType.authenticationMode().map({ args0 -> args0 }).orElse(null),
            lastKeySync = javaType.lastKeySync(),
            nodeIdentityReference = javaType.nodeIdentityReference().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.batch.kotlin.outputs.ComputeNodeIdentityReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            storageAccountId = javaType.storageAccountId(),
        )
    }
}
