@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property accountKey
 * @property accountName
 * @property azureFileUrl This is of the form 'https://{account}.file.core.windows.net/'.
 * @property mountOptions These are 'net use' options in Windows and 'mount' options in Linux.
 * @property relativeMountPath All file systems are mounted relative to the Batch mounts directory, accessible via the AZ_BATCH_NODE_MOUNTS_DIR environment variable.
 */
public data class AzureFileShareConfigurationResponse(
    public val accountKey: String,
    public val accountName: String,
    public val azureFileUrl: String,
    public val mountOptions: String? = null,
    public val relativeMountPath: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.batch.outputs.AzureFileShareConfigurationResponse): AzureFileShareConfigurationResponse = AzureFileShareConfigurationResponse(
            accountKey = javaType.accountKey(),
            accountName = javaType.accountName(),
            azureFileUrl = javaType.azureFileUrl(),
            mountOptions = javaType.mountOptions().map({ args0 -> args0 }).orElse(null),
            relativeMountPath = javaType.relativeMountPath(),
        )
    }
}
