@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Warning: This object is deprecated and will be removed after February, 2024. Please use the [Azure KeyVault Extension](https://learn.microsoft.com/azure/batch/batch-certificate-migration-guide) instead.
 * @property id
 * @property storeLocation The default value is currentUser. This property is applicable only for pools configured with Windows nodes (that is, created with cloudServiceConfiguration, or with virtualMachineConfiguration using a Windows image reference). For Linux compute nodes, the certificates are stored in a directory inside the task working directory and an environment variable AZ_BATCH_CERTIFICATES_DIR is supplied to the task to query for this location. For certificates with visibility of 'remoteUser', a 'certs' directory is created in the user's home directory (e.g., /home/{user-name}/certs) and certificates are placed in that directory.
 * @property storeName This property is applicable only for pools configured with Windows nodes (that is, created with cloudServiceConfiguration, or with virtualMachineConfiguration using a Windows image reference). Common store names include: My, Root, CA, Trust, Disallowed, TrustedPeople, TrustedPublisher, AuthRoot, AddressBook, but any custom store name can also be used. The default value is My.
 * @property visibility
 */
public data class CertificateReferenceResponse(
    public val id: String,
    public val storeLocation: String? = null,
    public val storeName: String? = null,
    public val visibility: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.batch.outputs.CertificateReferenceResponse): CertificateReferenceResponse = CertificateReferenceResponse(
            id = javaType.id(),
            storeLocation = javaType.storeLocation().map({ args0 -> args0 }).orElse(null),
            storeName = javaType.storeName().map({ args0 -> args0 }).orElse(null),
            visibility = javaType.visibility().map({ args0 -> args0 }),
        )
    }
}
