@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property osFamily Possible values are: 2 - OS Family 2, equivalent to Windows Server 2008 R2 SP1. 3 - OS Family 3, equivalent to Windows Server 2012. 4 - OS Family 4, equivalent to Windows Server 2012 R2. 5 - OS Family 5, equivalent to Windows Server 2016. 6 - OS Family 6, equivalent to Windows Server 2019. For more information, see Azure Guest OS Releases (https://azure.microsoft.com/documentation/articles/cloud-services-guestos-update-matrix/#releases).
 * @property osVersion The default value is * which specifies the latest operating system version for the specified OS family.
 */
public data class CloudServiceConfigurationResponse(
    public val osFamily: String,
    public val osVersion: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.batch.outputs.CloudServiceConfigurationResponse): CloudServiceConfigurationResponse = CloudServiceConfigurationResponse(
            osFamily = javaType.osFamily(),
            osVersion = javaType.osVersion().map({ args0 -> args0 }).orElse(null),
        )
    }
}
