@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The reference to a user assigned identity associated with the Batch pool which a compute node will use.
 * @property resourceId The ARM resource id of the user assigned identity.
 */
public data class ComputeNodeIdentityReferenceResponse(
    public val resourceId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.batch.outputs.ComputeNodeIdentityReferenceResponse): ComputeNodeIdentityReferenceResponse = ComputeNodeIdentityReferenceResponse(
            resourceId = javaType.resourceId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
