@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property containerImageNames This is the full image reference, as would be specified to "docker pull". An image will be sourced from the default Docker registry unless the image is fully qualified with an alternative registry.
 * @property containerRegistries If any images must be downloaded from a private registry which requires credentials, then those credentials must be provided here.
 * @property type
 */
public data class ContainerConfigurationResponse(
    public val containerImageNames: List<String>? = null,
    public val containerRegistries: List<ContainerRegistryResponse>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.batch.outputs.ContainerConfigurationResponse): ContainerConfigurationResponse = ContainerConfigurationResponse(
            containerImageNames = javaType.containerImageNames().map({ args0 -> args0 }),
            containerRegistries = javaType.containerRegistries().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.batch.kotlin.outputs.ContainerRegistryResponse.Companion.toKotlin(args0)
                })
            }),
            type = javaType.type(),
        )
    }
}
