@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Settings which will be used by the data disks associated to Compute Nodes in the Pool. When using attached data disks, you need to mount and format the disks from within a VM to use them.
 * @property caching Values are:
 *  none - The caching mode for the disk is not enabled.
 *  readOnly - The caching mode for the disk is read only.
 *  readWrite - The caching mode for the disk is read and write.
 *  The default value for caching is none. For information about the caching options see: https://blogs.msdn.microsoft.com/windowsazurestorage/2012/06/27/exploring-windows-azure-drives-disks-and-images/.
 * @property diskSizeGB
 * @property lun The lun is used to uniquely identify each data disk. If attaching multiple disks, each should have a distinct lun. The value must be between 0 and 63, inclusive.
 * @property storageAccountType If omitted, the default is "Standard_LRS". Values are:
 *  Standard_LRS - The data disk should use standard locally redundant storage.
 *  Premium_LRS - The data disk should use premium locally redundant storage.
 */
public data class DataDiskResponse(
    public val caching: String? = null,
    public val diskSizeGB: Int,
    public val lun: Int,
    public val storageAccountType: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.batch.outputs.DataDiskResponse): DataDiskResponse = DataDiskResponse(
            caching = javaType.caching().map({ args0 -> args0 }).orElse(null),
            diskSizeGB = javaType.diskSizeGB(),
            lun = javaType.lun(),
            storageAccountType = javaType.storageAccountType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
