@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The disk encryption configuration applied on compute nodes in the pool. Disk encryption configuration is not supported on Linux pool created with Virtual Machine Image or Shared Image Gallery Image.
 * @property targets On Linux pool, only "TemporaryDisk" is supported; on Windows pool, "OsDisk" and "TemporaryDisk" must be specified.
 */
public data class DiskEncryptionConfigurationResponse(
    public val targets: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.batch.outputs.DiskEncryptionConfigurationResponse): DiskEncryptionConfigurationResponse = DiskEncryptionConfigurationResponse(
            targets = javaType.targets().map({ args0 -> args0 }),
        )
    }
}
