@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Configures how customer data is encrypted inside the Batch account. By default, accounts are encrypted using a Microsoft managed key. For additional control, a customer-managed key can be used instead.
 * @property keySource Type of the key source.
 * @property keyVaultProperties Additional details when using Microsoft.KeyVault
 */
public data class EncryptionPropertiesResponse(
    public val keySource: String? = null,
    public val keyVaultProperties: KeyVaultPropertiesResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.batch.outputs.EncryptionPropertiesResponse): EncryptionPropertiesResponse = EncryptionPropertiesResponse(
            keySource = javaType.keySource().map({ args0 -> args0 }).orElse(null),
            keyVaultProperties = javaType.keyVaultProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.batch.kotlin.outputs.KeyVaultPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
