@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property resizeTimeout The default value is 15 minutes. Timeout values use ISO 8601 format. For example, use PT10M for 10 minutes. The minimum value is 5 minutes. If you specify a value less than 5 minutes, the Batch service rejects the request with an error; if you are calling the REST API directly, the HTTP status code is 400 (Bad Request).
 * @property targetDedicatedNodes At least one of targetDedicatedNodes, targetLowPriorityNodes must be set.
 * @property targetLowPriorityNodes At least one of targetDedicatedNodes, targetLowPriorityNodes must be set.
 */
public data class FixedScaleSettingsResponse(
    public val resizeTimeout: String? = null,
    public val targetDedicatedNodes: Int? = null,
    public val targetLowPriorityNodes: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.batch.outputs.FixedScaleSettingsResponse): FixedScaleSettingsResponse = FixedScaleSettingsResponse(
            resizeTimeout = javaType.resizeTimeout().map({ args0 -> args0 }).orElse(null),
            targetDedicatedNodes = javaType.targetDedicatedNodes().map({ args0 -> args0 }).orElse(null),
            targetLowPriorityNodes = javaType.targetLowPriorityNodes().map({ args0 -> args0 }).orElse(null),
        )
    }
}
