@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Contains information about an application in a Batch account.
 * @property allowUpdates A value indicating whether packages within the application may be overwritten using the same version string.
 * @property defaultVersion The package to use if a client requests the application but does not specify a version. This property can only be set to the name of an existing package.
 * @property displayName The display name for the application.
 * @property etag The ETag of the resource, used for concurrency statements.
 * @property id The ID of the resource.
 * @property name The name of the resource.
 * @property type The type of the resource.
 */
public data class GetApplicationResult(
    public val allowUpdates: Boolean? = null,
    public val defaultVersion: String? = null,
    public val displayName: String? = null,
    public val etag: String,
    public val id: String,
    public val name: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.batch.outputs.GetApplicationResult): GetApplicationResult = GetApplicationResult(
            allowUpdates = javaType.allowUpdates().map({ args0 -> args0 }).orElse(null),
            defaultVersion = javaType.defaultVersion().map({ args0 -> args0 }).orElse(null),
            displayName = javaType.displayName().map({ args0 -> args0 }).orElse(null),
            etag = javaType.etag(),
            id = javaType.id(),
            name = javaType.name(),
            type = javaType.type(),
        )
    }
}
