@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property backendPort This must be unique within a Batch pool. Acceptable values are between 1 and 65535 except for 22, 3389, 29876 and 29877 as these are reserved. If any reserved values are provided the request fails with HTTP status code 400.
 * @property frontendPortRangeEnd Acceptable values range between 1 and 65534 except ports from 50000 to 55000 which are reserved by the Batch service. All ranges within a pool must be distinct and cannot overlap. If any reserved or overlapping values are provided the request fails with HTTP status code 400.
 * @property frontendPortRangeStart Acceptable values range between 1 and 65534 except ports from 50000 to 55000 which are reserved. All ranges within a pool must be distinct and cannot overlap. If any reserved or overlapping values are provided the request fails with HTTP status code 400.
 * @property name The name must be unique within a Batch pool, can contain letters, numbers, underscores, periods, and hyphens. Names must start with a letter or number, must end with a letter, number, or underscore, and cannot exceed 77 characters.  If any invalid values are provided the request fails with HTTP status code 400.
 * @property networkSecurityGroupRules The maximum number of rules that can be specified across all the endpoints on a Batch pool is 25. If no network security group rules are specified, a default rule will be created to allow inbound access to the specified backendPort. If the maximum number of network security group rules is exceeded the request fails with HTTP status code 400.
 * @property protocol
 */
public data class InboundNatPoolResponse(
    public val backendPort: Int,
    public val frontendPortRangeEnd: Int,
    public val frontendPortRangeStart: Int,
    public val name: String,
    public val networkSecurityGroupRules: List<NetworkSecurityGroupRuleResponse>? = null,
    public val protocol: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.batch.outputs.InboundNatPoolResponse): InboundNatPoolResponse = InboundNatPoolResponse(
            backendPort = javaType.backendPort(),
            frontendPortRangeEnd = javaType.frontendPortRangeEnd(),
            frontendPortRangeStart = javaType.frontendPortRangeStart(),
            name = javaType.name(),
            networkSecurityGroupRules = javaType.networkSecurityGroupRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.batch.kotlin.outputs.NetworkSecurityGroupRuleResponse.Companion.toKotlin(args0)
                })
            }),
            protocol = javaType.protocol(),
        )
    }
}
