@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * KeyVault configuration when using an encryption KeySource of Microsoft.KeyVault.
 * @property keyIdentifier Full path to the secret with or without version. Example https://mykeyvault.vault.azure.net/keys/testkey/6e34a81fef704045975661e297a4c053. or https://mykeyvault.vault.azure.net/keys/testkey. To be usable the following prerequisites must be met:
 *  The Batch Account has a System Assigned identity
 *  The account identity has been granted Key/Get, Key/Unwrap and Key/Wrap permissions
 *  The KeyVault has soft-delete and purge protection enabled
 */
public data class KeyVaultPropertiesResponse(
    public val keyIdentifier: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.batch.outputs.KeyVaultPropertiesResponse): KeyVaultPropertiesResponse = KeyVaultPropertiesResponse(
            keyIdentifier = javaType.keyIdentifier().map({ args0 -> args0 }).orElse(null),
        )
    }
}
