@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A set of Azure Batch account keys.
 * @property accountName The Batch account name.
 * @property primary The primary key associated with the account.
 * @property secondary The secondary key associated with the account.
 */
public data class ListBatchAccountKeysResult(
    public val accountName: String,
    public val primary: String,
    public val secondary: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.batch.outputs.ListBatchAccountKeysResult): ListBatchAccountKeysResult = ListBatchAccountKeysResult(
            accountName = javaType.accountName(),
            primary = javaType.primary(),
            secondary = javaType.secondary(),
        )
    }
}
