@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property mountOptions These are 'net use' options in Windows and 'mount' options in Linux.
 * @property relativeMountPath All file systems are mounted relative to the Batch mounts directory, accessible via the AZ_BATCH_NODE_MOUNTS_DIR environment variable.
 * @property source
 */
public data class NFSMountConfigurationResponse(
    public val mountOptions: String? = null,
    public val relativeMountPath: String,
    public val source: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.batch.outputs.NFSMountConfigurationResponse): NFSMountConfigurationResponse = NFSMountConfigurationResponse(
            mountOptions = javaType.mountOptions().map({ args0 -> args0 }).orElse(null),
            relativeMountPath = javaType.relativeMountPath(),
            source = javaType.source(),
        )
    }
}
