@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Allocation configuration used by Batch Service to provision the nodes.
 * @property policy Allocation policy used by Batch Service to provision the nodes. If not specified, Batch will use the regional policy.
 */
public data class NodePlacementConfigurationResponse(
    public val policy: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.batch.outputs.NodePlacementConfigurationResponse): NodePlacementConfigurationResponse = NodePlacementConfigurationResponse(
            policy = javaType.policy().map({ args0 -> args0 }).orElse(null),
        )
    }
}
