@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property inboundNatPools The maximum number of inbound NAT pools per Batch pool is 5. If the maximum number of inbound NAT pools is exceeded the request fails with HTTP status code 400. This cannot be specified if the IPAddressProvisioningType is NoPublicIPAddresses.
 */
public data class PoolEndpointConfigurationResponse(
    public val inboundNatPools: List<InboundNatPoolResponse>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.batch.outputs.PoolEndpointConfigurationResponse): PoolEndpointConfigurationResponse = PoolEndpointConfigurationResponse(
            inboundNatPools = javaType.inboundNatPools().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.batch.kotlin.outputs.InboundNatPoolResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
