@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The private link service connection state of the private endpoint connection
 * @property actionsRequired
 * @property description
 * @property status
 */
public data class PrivateLinkServiceConnectionStateResponse(
    public val actionsRequired: String,
    public val description: String? = null,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.batch.outputs.PrivateLinkServiceConnectionStateResponse): PrivateLinkServiceConnectionStateResponse = PrivateLinkServiceConnectionStateResponse(
            actionsRequired = javaType.actionsRequired(),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            status = javaType.status(),
        )
    }
}
