@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The public IP Address configuration of the networking configuration of a Pool.
 * @property ipAddressIds The number of IPs specified here limits the maximum size of the Pool - 100 dedicated nodes or 100 Spot/low-priority nodes can be allocated for each public IP. For example, a pool needing 250 dedicated VMs would need at least 3 public IPs specified. Each element of this collection is of the form: /subscriptions/{subscription}/resourceGroups/{group}/providers/Microsoft.Network/publicIPAddresses/{ip}.
 * @property provision The default value is BatchManaged
 */
public data class PublicIPAddressConfigurationResponse(
    public val ipAddressIds: List<String>? = null,
    public val provision: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.batch.outputs.PublicIPAddressConfigurationResponse): PublicIPAddressConfigurationResponse = PublicIPAddressConfigurationResponse(
            ipAddressIds = javaType.ipAddressIds().map({ args0 -> args0 }),
            provision = javaType.provision().map({ args0 -> args0 }).orElse(null),
        )
    }
}
