@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property elevationLevel nonAdmin - The auto user is a standard user without elevated access. admin - The auto user is a user with elevated access and operates with full Administrator permissions. The default value is nonAdmin.
 * @property linuxUserConfiguration This property is ignored if specified on a Windows pool. If not specified, the user is created with the default options.
 * @property name
 * @property password
 * @property windowsUserConfiguration This property can only be specified if the user is on a Windows pool. If not specified and on a Windows pool, the user is created with the default options.
 */
public data class UserAccountResponse(
    public val elevationLevel: String? = null,
    public val linuxUserConfiguration: LinuxUserConfigurationResponse? = null,
    public val name: String,
    public val password: String,
    public val windowsUserConfiguration: WindowsUserConfigurationResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.batch.outputs.UserAccountResponse): UserAccountResponse = UserAccountResponse(
            elevationLevel = javaType.elevationLevel().map({ args0 -> args0 }).orElse(null),
            linuxUserConfiguration = javaType.linuxUserConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.batch.kotlin.outputs.LinuxUserConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            name = javaType.name(),
            password = javaType.password(),
            windowsUserConfiguration = javaType.windowsUserConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.batch.kotlin.outputs.WindowsUserConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
