@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property containerConfiguration If specified, setup is performed on each node in the pool to allow tasks to run in containers. All regular tasks and job manager tasks run on this pool must specify the containerSettings property, and all other tasks may specify it.
 * @property dataDisks This property must be specified if the compute nodes in the pool need to have empty data disks attached to them.
 * @property diskEncryptionConfiguration If specified, encryption is performed on each node in the pool during node provisioning.
 * @property extensions If specified, the extensions mentioned in this configuration will be installed on each node.
 * @property imageReference
 * @property licenseType This only applies to images that contain the Windows operating system, and should only be used when you hold valid on-premises licenses for the nodes which will be deployed. If omitted, no on-premises licensing discount is applied. Values are:
 *  Windows_Server - The on-premises license is for Windows Server.
 *  Windows_Client - The on-premises license is for Windows Client.
 * @property nodeAgentSkuId The Batch node agent is a program that runs on each node in the pool, and provides the command-and-control interface between the node and the Batch service. There are different implementations of the node agent, known as SKUs, for different operating systems. You must specify a node agent SKU which matches the selected image reference. To get the list of supported node agent SKUs along with their list of verified image references, see the 'List supported node agent SKUs' operation.
 * @property nodePlacementConfiguration This configuration will specify rules on how nodes in the pool will be physically allocated.
 * @property osDisk Contains configuration for ephemeral OSDisk settings.
 * @property windowsConfiguration This property must not be specified if the imageReference specifies a Linux OS image.
 */
public data class VirtualMachineConfigurationResponse(
    public val containerConfiguration: ContainerConfigurationResponse? = null,
    public val dataDisks: List<DataDiskResponse>? = null,
    public val diskEncryptionConfiguration: DiskEncryptionConfigurationResponse? = null,
    public val extensions: List<VMExtensionResponse>? = null,
    public val imageReference: ImageReferenceResponse,
    public val licenseType: String? = null,
    public val nodeAgentSkuId: String,
    public val nodePlacementConfiguration: NodePlacementConfigurationResponse? = null,
    public val osDisk: OSDiskResponse? = null,
    public val windowsConfiguration: WindowsConfigurationResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.batch.outputs.VirtualMachineConfigurationResponse): VirtualMachineConfigurationResponse = VirtualMachineConfigurationResponse(
            containerConfiguration = javaType.containerConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.batch.kotlin.outputs.ContainerConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            dataDisks = javaType.dataDisks().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.batch.kotlin.outputs.DataDiskResponse.Companion.toKotlin(args0)
                })
            }),
            diskEncryptionConfiguration = javaType.diskEncryptionConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.batch.kotlin.outputs.DiskEncryptionConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            extensions = javaType.extensions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.batch.kotlin.outputs.VMExtensionResponse.Companion.toKotlin(args0)
                })
            }),
            imageReference = javaType.imageReference().let({ args0 ->
                com.pulumi.azurenative.batch.kotlin.outputs.ImageReferenceResponse.Companion.toKotlin(args0)
            }),
            licenseType = javaType.licenseType().map({ args0 -> args0 }).orElse(null),
            nodeAgentSkuId = javaType.nodeAgentSkuId(),
            nodePlacementConfiguration = javaType.nodePlacementConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.batch.kotlin.outputs.NodePlacementConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            osDisk = javaType.osDisk().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.batch.kotlin.outputs.OSDiskResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            windowsConfiguration = javaType.windowsConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.batch.kotlin.outputs.WindowsConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
