@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.billing.kotlin

import com.pulumi.azurenative.billing.BillingFunctions.getBillingRoleAssignmentByBillingAccountPlain
import com.pulumi.azurenative.billing.BillingFunctions.getBillingRoleAssignmentByDepartmentPlain
import com.pulumi.azurenative.billing.BillingFunctions.getBillingRoleAssignmentByEnrollmentAccountPlain
import com.pulumi.azurenative.billing.BillingFunctions.listBillingAccountInvoiceSectionsByCreateSubscriptionPermissionPlain
import com.pulumi.azurenative.billing.kotlin.inputs.GetBillingRoleAssignmentByBillingAccountPlainArgs
import com.pulumi.azurenative.billing.kotlin.inputs.GetBillingRoleAssignmentByBillingAccountPlainArgsBuilder
import com.pulumi.azurenative.billing.kotlin.inputs.GetBillingRoleAssignmentByDepartmentPlainArgs
import com.pulumi.azurenative.billing.kotlin.inputs.GetBillingRoleAssignmentByDepartmentPlainArgsBuilder
import com.pulumi.azurenative.billing.kotlin.inputs.GetBillingRoleAssignmentByEnrollmentAccountPlainArgs
import com.pulumi.azurenative.billing.kotlin.inputs.GetBillingRoleAssignmentByEnrollmentAccountPlainArgsBuilder
import com.pulumi.azurenative.billing.kotlin.inputs.ListBillingAccountInvoiceSectionsByCreateSubscriptionPermissionPlainArgs
import com.pulumi.azurenative.billing.kotlin.inputs.ListBillingAccountInvoiceSectionsByCreateSubscriptionPermissionPlainArgsBuilder
import com.pulumi.azurenative.billing.kotlin.outputs.GetBillingRoleAssignmentByBillingAccountResult
import com.pulumi.azurenative.billing.kotlin.outputs.GetBillingRoleAssignmentByDepartmentResult
import com.pulumi.azurenative.billing.kotlin.outputs.GetBillingRoleAssignmentByEnrollmentAccountResult
import com.pulumi.azurenative.billing.kotlin.outputs.ListBillingAccountInvoiceSectionsByCreateSubscriptionPermissionResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.billing.kotlin.outputs.GetBillingRoleAssignmentByBillingAccountResult.Companion.toKotlin as getBillingRoleAssignmentByBillingAccountResultToKotlin
import com.pulumi.azurenative.billing.kotlin.outputs.GetBillingRoleAssignmentByDepartmentResult.Companion.toKotlin as getBillingRoleAssignmentByDepartmentResultToKotlin
import com.pulumi.azurenative.billing.kotlin.outputs.GetBillingRoleAssignmentByEnrollmentAccountResult.Companion.toKotlin as getBillingRoleAssignmentByEnrollmentAccountResultToKotlin
import com.pulumi.azurenative.billing.kotlin.outputs.ListBillingAccountInvoiceSectionsByCreateSubscriptionPermissionResult.Companion.toKotlin as listBillingAccountInvoiceSectionsByCreateSubscriptionPermissionResultToKotlin

public object BillingFunctions {
    /**
     * Gets a role assignment for the caller on a billing account. The operation is supported for billing accounts with agreement type Microsoft Partner Agreement, Microsoft Customer Agreement or Enterprise Agreement.
     * Azure REST API version: 2019-10-01-preview.
     * @param argument null
     * @return The role assignment
     */
    public suspend fun getBillingRoleAssignmentByBillingAccount(argument: GetBillingRoleAssignmentByBillingAccountPlainArgs): GetBillingRoleAssignmentByBillingAccountResult =
        getBillingRoleAssignmentByBillingAccountResultToKotlin(getBillingRoleAssignmentByBillingAccountPlain(argument.toJava()).await())

    /**
     * @see [getBillingRoleAssignmentByBillingAccount].
     * @param billingAccountName The ID that uniquely identifies a billing account.
     * @param billingRoleAssignmentName The ID that uniquely identifies a role assignment.
     * @return The role assignment
     */
    public suspend fun getBillingRoleAssignmentByBillingAccount(
        billingAccountName: String,
        billingRoleAssignmentName: String,
    ): GetBillingRoleAssignmentByBillingAccountResult {
        val argument = GetBillingRoleAssignmentByBillingAccountPlainArgs(
            billingAccountName = billingAccountName,
            billingRoleAssignmentName = billingRoleAssignmentName,
        )
        return getBillingRoleAssignmentByBillingAccountResultToKotlin(getBillingRoleAssignmentByBillingAccountPlain(argument.toJava()).await())
    }

    /**
     * @see [getBillingRoleAssignmentByBillingAccount].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;billing&#46;kotlin&#46;inputs&#46;GetBillingRoleAssignmentByBillingAccountPlainArgs].
     * @return The role assignment
     */
    public suspend fun getBillingRoleAssignmentByBillingAccount(argument: suspend GetBillingRoleAssignmentByBillingAccountPlainArgsBuilder.() -> Unit): GetBillingRoleAssignmentByBillingAccountResult {
        val builder = GetBillingRoleAssignmentByBillingAccountPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getBillingRoleAssignmentByBillingAccountResultToKotlin(getBillingRoleAssignmentByBillingAccountPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a role assignment for the caller on a department. The operation is supported only for billing accounts with agreement type Enterprise Agreement.
     * Azure REST API version: 2019-10-01-preview.
     * @param argument null
     * @return The role assignment
     */
    public suspend fun getBillingRoleAssignmentByDepartment(argument: GetBillingRoleAssignmentByDepartmentPlainArgs): GetBillingRoleAssignmentByDepartmentResult =
        getBillingRoleAssignmentByDepartmentResultToKotlin(getBillingRoleAssignmentByDepartmentPlain(argument.toJava()).await())

    /**
     * @see [getBillingRoleAssignmentByDepartment].
     * @param billingAccountName The ID that uniquely identifies a billing account.
     * @param billingRoleAssignmentName The ID that uniquely identifies a role assignment.
     * @param departmentName The ID that uniquely identifies a department.
     * @return The role assignment
     */
    public suspend fun getBillingRoleAssignmentByDepartment(
        billingAccountName: String,
        billingRoleAssignmentName: String,
        departmentName: String,
    ): GetBillingRoleAssignmentByDepartmentResult {
        val argument = GetBillingRoleAssignmentByDepartmentPlainArgs(
            billingAccountName = billingAccountName,
            billingRoleAssignmentName = billingRoleAssignmentName,
            departmentName = departmentName,
        )
        return getBillingRoleAssignmentByDepartmentResultToKotlin(getBillingRoleAssignmentByDepartmentPlain(argument.toJava()).await())
    }

    /**
     * @see [getBillingRoleAssignmentByDepartment].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;billing&#46;kotlin&#46;inputs&#46;GetBillingRoleAssignmentByDepartmentPlainArgs].
     * @return The role assignment
     */
    public suspend fun getBillingRoleAssignmentByDepartment(argument: suspend GetBillingRoleAssignmentByDepartmentPlainArgsBuilder.() -> Unit): GetBillingRoleAssignmentByDepartmentResult {
        val builder = GetBillingRoleAssignmentByDepartmentPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getBillingRoleAssignmentByDepartmentResultToKotlin(getBillingRoleAssignmentByDepartmentPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a role assignment for the caller on a enrollment Account. The operation is supported only for billing accounts with agreement type Enterprise Agreement.
     * Azure REST API version: 2019-10-01-preview.
     * @param argument null
     * @return The role assignment
     */
    public suspend fun getBillingRoleAssignmentByEnrollmentAccount(argument: GetBillingRoleAssignmentByEnrollmentAccountPlainArgs): GetBillingRoleAssignmentByEnrollmentAccountResult =
        getBillingRoleAssignmentByEnrollmentAccountResultToKotlin(getBillingRoleAssignmentByEnrollmentAccountPlain(argument.toJava()).await())

    /**
     * @see [getBillingRoleAssignmentByEnrollmentAccount].
     * @param billingAccountName The ID that uniquely identifies a billing account.
     * @param billingRoleAssignmentName The ID that uniquely identifies a role assignment.
     * @param enrollmentAccountName The ID that uniquely identifies an enrollment account.
     * @return The role assignment
     */
    public suspend fun getBillingRoleAssignmentByEnrollmentAccount(
        billingAccountName: String,
        billingRoleAssignmentName: String,
        enrollmentAccountName: String,
    ): GetBillingRoleAssignmentByEnrollmentAccountResult {
        val argument = GetBillingRoleAssignmentByEnrollmentAccountPlainArgs(
            billingAccountName = billingAccountName,
            billingRoleAssignmentName = billingRoleAssignmentName,
            enrollmentAccountName = enrollmentAccountName,
        )
        return getBillingRoleAssignmentByEnrollmentAccountResultToKotlin(getBillingRoleAssignmentByEnrollmentAccountPlain(argument.toJava()).await())
    }

    /**
     * @see [getBillingRoleAssignmentByEnrollmentAccount].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;billing&#46;kotlin&#46;inputs&#46;GetBillingRoleAssignmentByEnrollmentAccountPlainArgs].
     * @return The role assignment
     */
    public suspend fun getBillingRoleAssignmentByEnrollmentAccount(argument: suspend GetBillingRoleAssignmentByEnrollmentAccountPlainArgsBuilder.() -> Unit): GetBillingRoleAssignmentByEnrollmentAccountResult {
        val builder = GetBillingRoleAssignmentByEnrollmentAccountPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getBillingRoleAssignmentByEnrollmentAccountResultToKotlin(getBillingRoleAssignmentByEnrollmentAccountPlain(builtArgument.toJava()).await())
    }

    /**
     * Lists the invoice sections for which the user has permission to create Azure subscriptions. The operation is supported only for billing accounts with agreement type Microsoft Customer Agreement.
     * Azure REST API version: 2020-05-01.
     * Other available API versions: 2019-10-01-preview.
     * @param argument null
     * @return The list of invoice section properties with create subscription permission.
     */
    public suspend fun listBillingAccountInvoiceSectionsByCreateSubscriptionPermission(argument: ListBillingAccountInvoiceSectionsByCreateSubscriptionPermissionPlainArgs): ListBillingAccountInvoiceSectionsByCreateSubscriptionPermissionResult =
        listBillingAccountInvoiceSectionsByCreateSubscriptionPermissionResultToKotlin(listBillingAccountInvoiceSectionsByCreateSubscriptionPermissionPlain(argument.toJava()).await())

    /**
     * @see [listBillingAccountInvoiceSectionsByCreateSubscriptionPermission].
     * @param billingAccountName The ID that uniquely identifies a billing account.
     * @return The list of invoice section properties with create subscription permission.
     */
    public suspend fun listBillingAccountInvoiceSectionsByCreateSubscriptionPermission(billingAccountName: String): ListBillingAccountInvoiceSectionsByCreateSubscriptionPermissionResult {
        val argument = ListBillingAccountInvoiceSectionsByCreateSubscriptionPermissionPlainArgs(
            billingAccountName = billingAccountName,
        )
        return listBillingAccountInvoiceSectionsByCreateSubscriptionPermissionResultToKotlin(listBillingAccountInvoiceSectionsByCreateSubscriptionPermissionPlain(argument.toJava()).await())
    }

    /**
     * @see [listBillingAccountInvoiceSectionsByCreateSubscriptionPermission].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;billing&#46;kotlin&#46;inputs&#46;ListBillingAccountInvoiceSectionsByCreateSubscriptionPermissionPlainArgs].
     * @return The list of invoice section properties with create subscription permission.
     */
    public suspend fun listBillingAccountInvoiceSectionsByCreateSubscriptionPermission(argument: suspend ListBillingAccountInvoiceSectionsByCreateSubscriptionPermissionPlainArgsBuilder.() -> Unit): ListBillingAccountInvoiceSectionsByCreateSubscriptionPermissionResult {
        val builder = ListBillingAccountInvoiceSectionsByCreateSubscriptionPermissionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listBillingAccountInvoiceSectionsByCreateSubscriptionPermissionResultToKotlin(listBillingAccountInvoiceSectionsByCreateSubscriptionPermissionPlain(builtArgument.toJava()).await())
    }
}
