@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.billing.kotlin.inputs

import com.pulumi.azurenative.billing.inputs.GetBillingRoleAssignmentByBillingAccountPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property billingAccountName The ID that uniquely identifies a billing account.
 * @property billingRoleAssignmentName The ID that uniquely identifies a role assignment.
 */
public data class GetBillingRoleAssignmentByBillingAccountPlainArgs(
    public val billingAccountName: String,
    public val billingRoleAssignmentName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.billing.inputs.GetBillingRoleAssignmentByBillingAccountPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.billing.inputs.GetBillingRoleAssignmentByBillingAccountPlainArgs =
        com.pulumi.azurenative.billing.inputs.GetBillingRoleAssignmentByBillingAccountPlainArgs.builder()
            .billingAccountName(billingAccountName.let({ args0 -> args0 }))
            .billingRoleAssignmentName(billingRoleAssignmentName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetBillingRoleAssignmentByBillingAccountPlainArgs].
 */
@PulumiTagMarker
public class GetBillingRoleAssignmentByBillingAccountPlainArgsBuilder internal constructor() {
    private var billingAccountName: String? = null

    private var billingRoleAssignmentName: String? = null

    /**
     * @param value The ID that uniquely identifies a billing account.
     */
    @JvmName("hlolptodnsbpcqdu")
    public suspend fun billingAccountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.billingAccountName = mapped
    }

    /**
     * @param value The ID that uniquely identifies a role assignment.
     */
    @JvmName("lmdemgyugnbxwgyt")
    public suspend fun billingRoleAssignmentName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.billingRoleAssignmentName = mapped
    }

    internal fun build(): GetBillingRoleAssignmentByBillingAccountPlainArgs =
        GetBillingRoleAssignmentByBillingAccountPlainArgs(
            billingAccountName = billingAccountName ?: throw PulumiNullFieldException("billingAccountName"),
            billingRoleAssignmentName = billingRoleAssignmentName ?: throw
                PulumiNullFieldException("billingRoleAssignmentName"),
        )
}
