@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.billing.kotlin.inputs

import com.pulumi.azurenative.billing.inputs.GetBillingRoleAssignmentByEnrollmentAccountPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property billingAccountName The ID that uniquely identifies a billing account.
 * @property billingRoleAssignmentName The ID that uniquely identifies a role assignment.
 * @property enrollmentAccountName The ID that uniquely identifies an enrollment account.
 */
public data class GetBillingRoleAssignmentByEnrollmentAccountPlainArgs(
    public val billingAccountName: String,
    public val billingRoleAssignmentName: String,
    public val enrollmentAccountName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.billing.inputs.GetBillingRoleAssignmentByEnrollmentAccountPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.billing.inputs.GetBillingRoleAssignmentByEnrollmentAccountPlainArgs =
        com.pulumi.azurenative.billing.inputs.GetBillingRoleAssignmentByEnrollmentAccountPlainArgs.builder()
            .billingAccountName(billingAccountName.let({ args0 -> args0 }))
            .billingRoleAssignmentName(billingRoleAssignmentName.let({ args0 -> args0 }))
            .enrollmentAccountName(enrollmentAccountName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetBillingRoleAssignmentByEnrollmentAccountPlainArgs].
 */
@PulumiTagMarker
public class GetBillingRoleAssignmentByEnrollmentAccountPlainArgsBuilder internal constructor() {
    private var billingAccountName: String? = null

    private var billingRoleAssignmentName: String? = null

    private var enrollmentAccountName: String? = null

    /**
     * @param value The ID that uniquely identifies a billing account.
     */
    @JvmName("vytdojirtgydgwpx")
    public suspend fun billingAccountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.billingAccountName = mapped
    }

    /**
     * @param value The ID that uniquely identifies a role assignment.
     */
    @JvmName("dfoldpjsfpgqliwh")
    public suspend fun billingRoleAssignmentName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.billingRoleAssignmentName = mapped
    }

    /**
     * @param value The ID that uniquely identifies an enrollment account.
     */
    @JvmName("svidhidaxlayaywa")
    public suspend fun enrollmentAccountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.enrollmentAccountName = mapped
    }

    internal fun build(): GetBillingRoleAssignmentByEnrollmentAccountPlainArgs =
        GetBillingRoleAssignmentByEnrollmentAccountPlainArgs(
            billingAccountName = billingAccountName ?: throw PulumiNullFieldException("billingAccountName"),
            billingRoleAssignmentName = billingRoleAssignmentName ?: throw
                PulumiNullFieldException("billingRoleAssignmentName"),
            enrollmentAccountName = enrollmentAccountName ?: throw
                PulumiNullFieldException("enrollmentAccountName"),
        )
}
