@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.billing.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Details of the Azure plan.
 * @property skuDescription The sku description.
 * @property skuId The sku id.
 */
public data class AzurePlanResponse(
    public val skuDescription: String,
    public val skuId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.billing.outputs.AzurePlanResponse): AzurePlanResponse = AzurePlanResponse(
            skuDescription = javaType.skuDescription(),
            skuId = javaType.skuId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
