@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.billing.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The role assignment
 * @property createdByPrincipalId The principal Id of the user who created the role assignment.
 * @property createdByPrincipalTenantId The tenant Id of the user who created the role assignment.
 * @property createdByUserEmailAddress The email address of the user who created the role assignment. This is supported only for billing accounts with agreement type Enterprise Agreement.
 * @property createdOn The date the role assignment was created.
 * @property id Resource Id.
 * @property name Resource name.
 * @property principalId The principal id of the user to whom the role was assigned.
 * @property principalTenantId The principal tenant id of the user to whom the role was assigned.
 * @property roleDefinitionId The ID of the role definition.
 * @property scope The scope at which the role was assigned.
 * @property type Resource type.
 * @property userAuthenticationType The authentication type of the user, whether Organization or MSA, of the user to whom the role was assigned. This is supported only for billing accounts with agreement type Enterprise Agreement.
 * @property userEmailAddress The email address of the user to whom the role was assigned. This is supported only for billing accounts with agreement type Enterprise Agreement.
 */
public data class GetBillingRoleAssignmentByDepartmentResult(
    public val createdByPrincipalId: String,
    public val createdByPrincipalTenantId: String,
    public val createdByUserEmailAddress: String,
    public val createdOn: String,
    public val id: String,
    public val name: String,
    public val principalId: String? = null,
    public val principalTenantId: String? = null,
    public val roleDefinitionId: String? = null,
    public val scope: String,
    public val type: String,
    public val userAuthenticationType: String? = null,
    public val userEmailAddress: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.billing.outputs.GetBillingRoleAssignmentByDepartmentResult): GetBillingRoleAssignmentByDepartmentResult = GetBillingRoleAssignmentByDepartmentResult(
            createdByPrincipalId = javaType.createdByPrincipalId(),
            createdByPrincipalTenantId = javaType.createdByPrincipalTenantId(),
            createdByUserEmailAddress = javaType.createdByUserEmailAddress(),
            createdOn = javaType.createdOn(),
            id = javaType.id(),
            name = javaType.name(),
            principalId = javaType.principalId().map({ args0 -> args0 }).orElse(null),
            principalTenantId = javaType.principalTenantId().map({ args0 -> args0 }).orElse(null),
            roleDefinitionId = javaType.roleDefinitionId().map({ args0 -> args0 }).orElse(null),
            scope = javaType.scope(),
            type = javaType.type(),
            userAuthenticationType = javaType.userAuthenticationType().map({ args0 -> args0 }).orElse(null),
            userEmailAddress = javaType.userEmailAddress().map({ args0 -> args0 }).orElse(null),
        )
    }
}
