@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.billing.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Invoice section properties with create subscription permission.
 * @property billingProfileDisplayName The name of the billing profile for the invoice section.
 * @property billingProfileId The ID of the billing profile for the invoice section.
 * @property billingProfileSpendingLimit The billing profile spending limit.
 * @property billingProfileStatus The status of the billing profile.
 * @property billingProfileStatusReasonCode Reason for the specified billing profile status.
 * @property billingProfileSystemId The system generated unique identifier for a billing profile.
 * @property enabledAzurePlans Enabled azure plans for the associated billing profile.
 * @property invoiceSectionDisplayName The name of the invoice section.
 * @property invoiceSectionId The ID of the invoice section.
 * @property invoiceSectionSystemId The system generated unique identifier for an invoice section.
 */
public data class InvoiceSectionWithCreateSubPermissionResponse(
    public val billingProfileDisplayName: String,
    public val billingProfileId: String,
    public val billingProfileSpendingLimit: String,
    public val billingProfileStatus: String,
    public val billingProfileStatusReasonCode: String,
    public val billingProfileSystemId: String,
    public val enabledAzurePlans: List<AzurePlanResponse>? = null,
    public val invoiceSectionDisplayName: String,
    public val invoiceSectionId: String,
    public val invoiceSectionSystemId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.billing.outputs.InvoiceSectionWithCreateSubPermissionResponse): InvoiceSectionWithCreateSubPermissionResponse =
            InvoiceSectionWithCreateSubPermissionResponse(
                billingProfileDisplayName = javaType.billingProfileDisplayName(),
                billingProfileId = javaType.billingProfileId(),
                billingProfileSpendingLimit = javaType.billingProfileSpendingLimit(),
                billingProfileStatus = javaType.billingProfileStatus(),
                billingProfileStatusReasonCode = javaType.billingProfileStatusReasonCode(),
                billingProfileSystemId = javaType.billingProfileSystemId(),
                enabledAzurePlans = javaType.enabledAzurePlans().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.billing.kotlin.outputs.AzurePlanResponse.Companion.toKotlin(args0)
                    })
                }),
                invoiceSectionDisplayName = javaType.invoiceSectionDisplayName(),
                invoiceSectionId = javaType.invoiceSectionId(),
                invoiceSectionSystemId = javaType.invoiceSectionSystemId(),
            )
    }
}
