@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.billing.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The list of invoice section properties with create subscription permission.
 * @property nextLink The link (url) to the next page of results.
 * @property value The list of invoice section properties with create subscription permission.
 */
public data class ListBillingAccountInvoiceSectionsByCreateSubscriptionPermissionResult(
    public val nextLink: String,
    public val `value`: List<InvoiceSectionWithCreateSubPermissionResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.billing.outputs.ListBillingAccountInvoiceSectionsByCreateSubscriptionPermissionResult): ListBillingAccountInvoiceSectionsByCreateSubscriptionPermissionResult =
            ListBillingAccountInvoiceSectionsByCreateSubscriptionPermissionResult(
                nextLink = javaType.nextLink(),
                `value` = javaType.`value`().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.billing.kotlin.outputs.InvoiceSectionWithCreateSubPermissionResponse.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
