@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.blueprint.kotlin

import com.pulumi.azurenative.blueprint.kotlin.outputs.AssignmentLockSettingsResponse
import com.pulumi.azurenative.blueprint.kotlin.outputs.AssignmentStatusResponse
import com.pulumi.azurenative.blueprint.kotlin.outputs.ManagedServiceIdentityResponse
import com.pulumi.azurenative.blueprint.kotlin.outputs.ParameterValueResponse
import com.pulumi.azurenative.blueprint.kotlin.outputs.ResourceGroupValueResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.blueprint.kotlin.outputs.AssignmentLockSettingsResponse.Companion.toKotlin as assignmentLockSettingsResponseToKotlin
import com.pulumi.azurenative.blueprint.kotlin.outputs.AssignmentStatusResponse.Companion.toKotlin as assignmentStatusResponseToKotlin
import com.pulumi.azurenative.blueprint.kotlin.outputs.ManagedServiceIdentityResponse.Companion.toKotlin as managedServiceIdentityResponseToKotlin
import com.pulumi.azurenative.blueprint.kotlin.outputs.ParameterValueResponse.Companion.toKotlin as parameterValueResponseToKotlin
import com.pulumi.azurenative.blueprint.kotlin.outputs.ResourceGroupValueResponse.Companion.toKotlin as resourceGroupValueResponseToKotlin

/**
 * Builder for [Assignment].
 */
@PulumiTagMarker
public class AssignmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AssignmentArgs = AssignmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AssignmentArgsBuilder.() -> Unit) {
        val builder = AssignmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Assignment {
        val builtJavaResource = com.pulumi.azurenative.blueprint.Assignment(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Assignment(builtJavaResource)
    }
}

/**
 * Represents a blueprint assignment.
 * Azure REST API version: 2018-11-01-preview. Prior API version in Azure Native 1.x: 2018-11-01-preview.
 * Other available API versions: 2017-11-11-preview.
 * ## Example Usage
 * ### Assignment with system-assigned managed identity at management group scope
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var assignment = new AzureNative.Blueprint.Assignment("assignment", new()
 *     {
 *         AssignmentName = "assignSimpleBlueprint",
 *         BlueprintId = "/providers/Microsoft.Management/managementGroups/ContosoOnlineGroup/providers/Microsoft.Blueprint/blueprints/simpleBlueprint",
 *         Description = "enforce pre-defined simpleBlueprint to this XXXXXXXX subscription.",
 *         Identity = new AzureNative.Blueprint.Inputs.ManagedServiceIdentityArgs
 *         {
 *             Type = AzureNative.Blueprint.ManagedServiceIdentityType.SystemAssigned,
 *         },
 *         Location = "eastus",
 *         Parameters =
 *         {
 *             { "costCenter", new AzureNative.Blueprint.Inputs.ParameterValueArgs
 *             {
 *                 Value = "Contoso/Online/Shopping/Production",
 *             } },
 *             { "owners", new AzureNative.Blueprint.Inputs.ParameterValueArgs
 *             {
 *                 Value = new[]
 *                 {
 *                     "johnDoe@contoso.com",
 *                     "johnsteam@contoso.com",
 *                 },
 *             } },
 *             { "storageAccountType", new AzureNative.Blueprint.Inputs.ParameterValueArgs
 *             {
 *                 Value = "Standard_LRS",
 *             } },
 *         },
 *         ResourceGroups =
 *         {
 *             { "storageRG", new AzureNative.Blueprint.Inputs.ResourceGroupValueArgs
 *             {
 *                 Location = "eastus",
 *                 Name = "defaultRG",
 *             } },
 *         },
 *         ResourceScope = "managementGroups/ContosoOnlineGroup",
 *         Scope = "subscriptions/00000000-0000-0000-0000-000000000000",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/blueprint/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := blueprint.NewAssignment(ctx, "assignment", &blueprint.AssignmentArgs{
 * 			AssignmentName: pulumi.String("assignSimpleBlueprint"),
 * 			BlueprintId:    pulumi.String("/providers/Microsoft.Management/managementGroups/ContosoOnlineGroup/providers/Microsoft.Blueprint/blueprints/simpleBlueprint"),
 * 			Description:    pulumi.String("enforce pre-defined simpleBlueprint to this XXXXXXXX subscription."),
 * 			Identity: &blueprint.ManagedServiceIdentityArgs{
 * 				Type: pulumi.String(blueprint.ManagedServiceIdentityTypeSystemAssigned),
 * 			},
 * 			Location: pulumi.String("eastus"),
 * 			Parameters: blueprint.ParameterValueMap{
 * 				"costCenter": &blueprint.ParameterValueArgs{
 * 					Value: pulumi.Any("Contoso/Online/Shopping/Production"),
 * 				},
 * 				"owners": &blueprint.ParameterValueArgs{
 * 					Value: pulumi.Any{
 * 						"johnDoe@contoso.com",
 * 						"johnsteam@contoso.com",
 * 					},
 * 				},
 * 				"storageAccountType": &blueprint.ParameterValueArgs{
 * 					Value: pulumi.Any("Standard_LRS"),
 * 				},
 * 			},
 * 			ResourceGroups: blueprint.ResourceGroupValueMap{
 * 				"storageRG": &blueprint.ResourceGroupValueArgs{
 * 					Location: pulumi.String("eastus"),
 * 					Name:     pulumi.String("defaultRG"),
 * 				},
 * 			},
 * 			ResourceScope: pulumi.String("managementGroups/ContosoOnlineGroup"),
 * 			Scope:         pulumi.String("subscriptions/00000000-0000-0000-0000-000000000000"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.blueprint.Assignment;
 * import com.pulumi.azurenative.blueprint.AssignmentArgs;
 * import com.pulumi.azurenative.blueprint.inputs.ManagedServiceIdentityArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var assignment = new Assignment("assignment", AssignmentArgs.builder()
 *             .assignmentName("assignSimpleBlueprint")
 *             .blueprintId("/providers/Microsoft.Management/managementGroups/ContosoOnlineGroup/providers/Microsoft.Blueprint/blueprints/simpleBlueprint")
 *             .description("enforce pre-defined simpleBlueprint to this XXXXXXXX subscription.")
 *             .identity(ManagedServiceIdentityArgs.builder()
 *                 .type("SystemAssigned")
 *                 .build())
 *             .location("eastus")
 *             .parameters(Map.ofEntries(
 *                 Map.entry("costCenter", Map.of("value", "Contoso/Online/Shopping/Production")),
 *                 Map.entry("owners", Map.of("value",
 *                     "johnDoe@contoso.com",
 *                     "johnsteam@contoso.com")),
 *                 Map.entry("storageAccountType", Map.of("value", "Standard_LRS"))
 *             ))
 *             .resourceGroups(Map.of("storageRG", Map.ofEntries(
 *                 Map.entry("location", "eastus"),
 *                 Map.entry("name", "defaultRG")
 *             )))
 *             .resourceScope("managementGroups/ContosoOnlineGroup")
 *             .scope("subscriptions/00000000-0000-0000-0000-000000000000")
 *             .build());
 *     }
 * }
 * ```
 * ### Assignment with system-assigned managed identity at subscription scope
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var assignment = new AzureNative.Blueprint.Assignment("assignment", new()
 *     {
 *         AssignmentName = "assignSimpleBlueprint",
 *         BlueprintId = "/providers/Microsoft.Management/managementGroups/ContosoOnlineGroup/providers/Microsoft.Blueprint/blueprints/simpleBlueprint",
 *         Description = "enforce pre-defined simpleBlueprint to this XXXXXXXX subscription.",
 *         Identity = new AzureNative.Blueprint.Inputs.ManagedServiceIdentityArgs
 *         {
 *             Type = AzureNative.Blueprint.ManagedServiceIdentityType.SystemAssigned,
 *         },
 *         Location = "eastus",
 *         Parameters =
 *         {
 *             { "costCenter", new AzureNative.Blueprint.Inputs.ParameterValueArgs
 *             {
 *                 Value = "Contoso/Online/Shopping/Production",
 *             } },
 *             { "owners", new AzureNative.Blueprint.Inputs.ParameterValueArgs
 *             {
 *                 Value = new[]
 *                 {
 *                     "johnDoe@contoso.com",
 *                     "johnsteam@contoso.com",
 *                 },
 *             } },
 *             { "storageAccountType", new AzureNative.Blueprint.Inputs.ParameterValueArgs
 *             {
 *                 Value = "Standard_LRS",
 *             } },
 *         },
 *         ResourceGroups =
 *         {
 *             { "storageRG", new AzureNative.Blueprint.Inputs.ResourceGroupValueArgs
 *             {
 *                 Location = "eastus",
 *                 Name = "defaultRG",
 *             } },
 *         },
 *         ResourceScope = "subscriptions/00000000-0000-0000-0000-000000000000",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/blueprint/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := blueprint.NewAssignment(ctx, "assignment", &blueprint.AssignmentArgs{
 * 			AssignmentName: pulumi.String("assignSimpleBlueprint"),
 * 			BlueprintId:    pulumi.String("/providers/Microsoft.Management/managementGroups/ContosoOnlineGroup/providers/Microsoft.Blueprint/blueprints/simpleBlueprint"),
 * 			Description:    pulumi.String("enforce pre-defined simpleBlueprint to this XXXXXXXX subscription."),
 * 			Identity: &blueprint.ManagedServiceIdentityArgs{
 * 				Type: pulumi.String(blueprint.ManagedServiceIdentityTypeSystemAssigned),
 * 			},
 * 			Location: pulumi.String("eastus"),
 * 			Parameters: blueprint.ParameterValueMap{
 * 				"costCenter": &blueprint.ParameterValueArgs{
 * 					Value: pulumi.Any("Contoso/Online/Shopping/Production"),
 * 				},
 * 				"owners": &blueprint.ParameterValueArgs{
 * 					Value: pulumi.Any{
 * 						"johnDoe@contoso.com",
 * 						"johnsteam@contoso.com",
 * 					},
 * 				},
 * 				"storageAccountType": &blueprint.ParameterValueArgs{
 * 					Value: pulumi.Any("Standard_LRS"),
 * 				},
 * 			},
 * 			ResourceGroups: blueprint.ResourceGroupValueMap{
 * 				"storageRG": &blueprint.ResourceGroupValueArgs{
 * 					Location: pulumi.String("eastus"),
 * 					Name:     pulumi.String("defaultRG"),
 * 				},
 * 			},
 * 			ResourceScope: pulumi.String("subscriptions/00000000-0000-0000-0000-000000000000"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.blueprint.Assignment;
 * import com.pulumi.azurenative.blueprint.AssignmentArgs;
 * import com.pulumi.azurenative.blueprint.inputs.ManagedServiceIdentityArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var assignment = new Assignment("assignment", AssignmentArgs.builder()
 *             .assignmentName("assignSimpleBlueprint")
 *             .blueprintId("/providers/Microsoft.Management/managementGroups/ContosoOnlineGroup/providers/Microsoft.Blueprint/blueprints/simpleBlueprint")
 *             .description("enforce pre-defined simpleBlueprint to this XXXXXXXX subscription.")
 *             .identity(ManagedServiceIdentityArgs.builder()
 *                 .type("SystemAssigned")
 *                 .build())
 *             .location("eastus")
 *             .parameters(Map.ofEntries(
 *                 Map.entry("costCenter", Map.of("value", "Contoso/Online/Shopping/Production")),
 *                 Map.entry("owners", Map.of("value",
 *                     "johnDoe@contoso.com",
 *                     "johnsteam@contoso.com")),
 *                 Map.entry("storageAccountType", Map.of("value", "Standard_LRS"))
 *             ))
 *             .resourceGroups(Map.of("storageRG", Map.ofEntries(
 *                 Map.entry("location", "eastus"),
 *                 Map.entry("name", "defaultRG")
 *             )))
 *             .resourceScope("subscriptions/00000000-0000-0000-0000-000000000000")
 *             .build());
 *     }
 * }
 * ```
 * ### Assignment with user-assigned managed identity at management group scope
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var assignment = new AzureNative.Blueprint.Assignment("assignment", new()
 *     {
 *         AssignmentName = "assignSimpleBlueprint",
 *         BlueprintId = "/providers/Microsoft.Management/managementGroups/ContosoOnlineGroup/providers/Microsoft.Blueprint/blueprints/simpleBlueprint",
 *         Description = "enforce pre-defined simpleBlueprint to this XXXXXXXX subscription.",
 *         Identity = new AzureNative.Blueprint.Inputs.ManagedServiceIdentityArgs
 *         {
 *             Type = AzureNative.Blueprint.ManagedServiceIdentityType.UserAssigned,
 *             UserAssignedIdentities =
 *             {
 *                 { "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/contoso-resource-group/providers/Microsoft.ManagedIdentity/userAssignedIdentities/contoso-identity", null },
 *             },
 *         },
 *         Location = "eastus",
 *         Parameters =
 *         {
 *             { "costCenter", new AzureNative.Blueprint.Inputs.ParameterValueArgs
 *             {
 *                 Value = "Contoso/Online/Shopping/Production",
 *             } },
 *             { "owners", new AzureNative.Blueprint.Inputs.ParameterValueArgs
 *             {
 *                 Value = new[]
 *                 {
 *                     "johnDoe@contoso.com",
 *                     "johnsteam@contoso.com",
 *                 },
 *             } },
 *             { "storageAccountType", new AzureNative.Blueprint.Inputs.ParameterValueArgs
 *             {
 *                 Value = "Standard_LRS",
 *             } },
 *         },
 *         ResourceGroups =
 *         {
 *             { "storageRG", new AzureNative.Blueprint.Inputs.ResourceGroupValueArgs
 *             {
 *                 Location = "eastus",
 *                 Name = "defaultRG",
 *             } },
 *         },
 *         ResourceScope = "managementGroups/ContosoOnlineGroup",
 *         Scope = "subscriptions/00000000-0000-0000-0000-000000000000",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/blueprint/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := blueprint.NewAssignment(ctx, "assignment", &blueprint.AssignmentArgs{
 * 			AssignmentName: pulumi.String("assignSimpleBlueprint"),
 * 			BlueprintId:    pulumi.String("/providers/Microsoft.Management/managementGroups/ContosoOnlineGroup/providers/Microsoft.Blueprint/blueprints/simpleBlueprint"),
 * 			Description:    pulumi.String("enforce pre-defined simpleBlueprint to this XXXXXXXX subscription."),
 * 			Identity: &blueprint.ManagedServiceIdentityArgs{
 * 				Type: pulumi.String(blueprint.ManagedServiceIdentityTypeUserAssigned),
 * 				UserAssignedIdentities: blueprint.UserAssignedIdentityMap{
 * 					"/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/contoso-resource-group/providers/Microsoft.ManagedIdentity/userAssignedIdentities/contoso-identity": nil,
 * 				},
 * 			},
 * 			Location: pulumi.String("eastus"),
 * 			Parameters: blueprint.ParameterValueMap{
 * 				"costCenter": &blueprint.ParameterValueArgs{
 * 					Value: pulumi.Any("Contoso/Online/Shopping/Production"),
 * 				},
 * 				"owners": &blueprint.ParameterValueArgs{
 * 					Value: pulumi.Any{
 * 						"johnDoe@contoso.com",
 * 						"johnsteam@contoso.com",
 * 					},
 * 				},
 * 				"storageAccountType": &blueprint.ParameterValueArgs{
 * 					Value: pulumi.Any("Standard_LRS"),
 * 				},
 * 			},
 * 			ResourceGroups: blueprint.ResourceGroupValueMap{
 * 				"storageRG": &blueprint.ResourceGroupValueArgs{
 * 					Location: pulumi.String("eastus"),
 * 					Name:     pulumi.String("defaultRG"),
 * 				},
 * 			},
 * 			ResourceScope: pulumi.String("managementGroups/ContosoOnlineGroup"),
 * 			Scope:         pulumi.String("subscriptions/00000000-0000-0000-0000-000000000000"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.blueprint.Assignment;
 * import com.pulumi.azurenative.blueprint.AssignmentArgs;
 * import com.pulumi.azurenative.blueprint.inputs.ManagedServiceIdentityArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var assignment = new Assignment("assignment", AssignmentArgs.builder()
 *             .assignmentName("assignSimpleBlueprint")
 *             .blueprintId("/providers/Microsoft.Management/managementGroups/ContosoOnlineGroup/providers/Microsoft.Blueprint/blueprints/simpleBlueprint")
 *             .description("enforce pre-defined simpleBlueprint to this XXXXXXXX subscription.")
 *             .identity(ManagedServiceIdentityArgs.builder()
 *                 .type("UserAssigned")
 *                 .userAssignedIdentities(Map.of("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/contoso-resource-group/providers/Microsoft.ManagedIdentity/userAssignedIdentities/contoso-identity", ))
 *                 .build())
 *             .location("eastus")
 *             .parameters(Map.ofEntries(
 *                 Map.entry("costCenter", Map.of("value", "Contoso/Online/Shopping/Production")),
 *                 Map.entry("owners", Map.of("value",
 *                     "johnDoe@contoso.com",
 *                     "johnsteam@contoso.com")),
 *                 Map.entry("storageAccountType", Map.of("value", "Standard_LRS"))
 *             ))
 *             .resourceGroups(Map.of("storageRG", Map.ofEntries(
 *                 Map.entry("location", "eastus"),
 *                 Map.entry("name", "defaultRG")
 *             )))
 *             .resourceScope("managementGroups/ContosoOnlineGroup")
 *             .scope("subscriptions/00000000-0000-0000-0000-000000000000")
 *             .build());
 *     }
 * }
 * ```
 * ### Assignment with user-assigned managed identity at subscription scope
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var assignment = new AzureNative.Blueprint.Assignment("assignment", new()
 *     {
 *         AssignmentName = "assignSimpleBlueprint",
 *         BlueprintId = "/providers/Microsoft.Management/managementGroups/ContosoOnlineGroup/providers/Microsoft.Blueprint/blueprints/simpleBlueprint",
 *         Description = "enforce pre-defined simpleBlueprint to this XXXXXXXX subscription.",
 *         Identity = new AzureNative.Blueprint.Inputs.ManagedServiceIdentityArgs
 *         {
 *             Type = AzureNative.Blueprint.ManagedServiceIdentityType.UserAssigned,
 *             UserAssignedIdentities =
 *             {
 *                 { "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/contoso-resource-group/providers/Microsoft.ManagedIdentity/userAssignedIdentities/contoso-identity", null },
 *             },
 *         },
 *         Location = "eastus",
 *         Parameters =
 *         {
 *             { "costCenter", new AzureNative.Blueprint.Inputs.ParameterValueArgs
 *             {
 *                 Value = "Contoso/Online/Shopping/Production",
 *             } },
 *             { "owners", new AzureNative.Blueprint.Inputs.ParameterValueArgs
 *             {
 *                 Value = new[]
 *                 {
 *                     "johnDoe@contoso.com",
 *                     "johnsteam@contoso.com",
 *                 },
 *             } },
 *             { "storageAccountType", new AzureNative.Blueprint.Inputs.ParameterValueArgs
 *             {
 *                 Value = "Standard_LRS",
 *             } },
 *         },
 *         ResourceGroups =
 *         {
 *             { "storageRG", new AzureNative.Blueprint.Inputs.ResourceGroupValueArgs
 *             {
 *                 Location = "eastus",
 *                 Name = "defaultRG",
 *             } },
 *         },
 *         ResourceScope = "subscriptions/00000000-0000-0000-0000-000000000000",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/blueprint/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := blueprint.NewAssignment(ctx, "assignment", &blueprint.AssignmentArgs{
 * 			AssignmentName: pulumi.String("assignSimpleBlueprint"),
 * 			BlueprintId:    pulumi.String("/providers/Microsoft.Management/managementGroups/ContosoOnlineGroup/providers/Microsoft.Blueprint/blueprints/simpleBlueprint"),
 * 			Description:    pulumi.String("enforce pre-defined simpleBlueprint to this XXXXXXXX subscription."),
 * 			Identity: &blueprint.ManagedServiceIdentityArgs{
 * 				Type: pulumi.String(blueprint.ManagedServiceIdentityTypeUserAssigned),
 * 				UserAssignedIdentities: blueprint.UserAssignedIdentityMap{
 * 					"/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/contoso-resource-group/providers/Microsoft.ManagedIdentity/userAssignedIdentities/contoso-identity": nil,
 * 				},
 * 			},
 * 			Location: pulumi.String("eastus"),
 * 			Parameters: blueprint.ParameterValueMap{
 * 				"costCenter": &blueprint.ParameterValueArgs{
 * 					Value: pulumi.Any("Contoso/Online/Shopping/Production"),
 * 				},
 * 				"owners": &blueprint.ParameterValueArgs{
 * 					Value: pulumi.Any{
 * 						"johnDoe@contoso.com",
 * 						"johnsteam@contoso.com",
 * 					},
 * 				},
 * 				"storageAccountType": &blueprint.ParameterValueArgs{
 * 					Value: pulumi.Any("Standard_LRS"),
 * 				},
 * 			},
 * 			ResourceGroups: blueprint.ResourceGroupValueMap{
 * 				"storageRG": &blueprint.ResourceGroupValueArgs{
 * 					Location: pulumi.String("eastus"),
 * 					Name:     pulumi.String("defaultRG"),
 * 				},
 * 			},
 * 			ResourceScope: pulumi.String("subscriptions/00000000-0000-0000-0000-000000000000"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.blueprint.Assignment;
 * import com.pulumi.azurenative.blueprint.AssignmentArgs;
 * import com.pulumi.azurenative.blueprint.inputs.ManagedServiceIdentityArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var assignment = new Assignment("assignment", AssignmentArgs.builder()
 *             .assignmentName("assignSimpleBlueprint")
 *             .blueprintId("/providers/Microsoft.Management/managementGroups/ContosoOnlineGroup/providers/Microsoft.Blueprint/blueprints/simpleBlueprint")
 *             .description("enforce pre-defined simpleBlueprint to this XXXXXXXX subscription.")
 *             .identity(ManagedServiceIdentityArgs.builder()
 *                 .type("UserAssigned")
 *                 .userAssignedIdentities(Map.of("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/contoso-resource-group/providers/Microsoft.ManagedIdentity/userAssignedIdentities/contoso-identity", ))
 *                 .build())
 *             .location("eastus")
 *             .parameters(Map.ofEntries(
 *                 Map.entry("costCenter", Map.of("value", "Contoso/Online/Shopping/Production")),
 *                 Map.entry("owners", Map.of("value",
 *                     "johnDoe@contoso.com",
 *                     "johnsteam@contoso.com")),
 *                 Map.entry("storageAccountType", Map.of("value", "Standard_LRS"))
 *             ))
 *             .resourceGroups(Map.of("storageRG", Map.ofEntries(
 *                 Map.entry("location", "eastus"),
 *                 Map.entry("name", "defaultRG")
 *             )))
 *             .resourceScope("subscriptions/00000000-0000-0000-0000-000000000000")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:blueprint:Assignment assignSimpleBlueprint /{resourceScope}/providers/Microsoft.Blueprint/blueprintAssignments/{assignmentName}
 * ```
 */
public class Assignment internal constructor(
    override val javaResource: com.pulumi.azurenative.blueprint.Assignment,
) : KotlinCustomResource(javaResource, AssignmentMapper) {
    /**
     * ID of the published version of a blueprint definition.
     */
    public val blueprintId: Output<String>?
        get() = javaResource.blueprintId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Multi-line explain this resource.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * One-liner string explain this resource.
     */
    public val displayName: Output<String>?
        get() = javaResource.displayName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Managed identity for this blueprint assignment.
     */
    public val identity: Output<ManagedServiceIdentityResponse>
        get() = javaResource.identity().applyValue({ args0 ->
            args0.let({ args0 ->
                managedServiceIdentityResponseToKotlin(args0)
            })
        })

    /**
     * The location of this blueprint assignment.
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Defines how resources deployed by a blueprint assignment are locked.
     */
    public val locks: Output<AssignmentLockSettingsResponse>?
        get() = javaResource.locks().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    assignmentLockSettingsResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Name of this resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Blueprint assignment parameter values.
     */
    public val parameters: Output<Map<String, ParameterValueResponse>>
        get() = javaResource.parameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value.let({ args0 -> parameterValueResponseToKotlin(args0) }))
            }).toMap()
        })

    /**
     * State of the blueprint assignment.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Names and locations of resource group placeholders.
     */
    public val resourceGroups: Output<Map<String, ResourceGroupValueResponse>>
        get() = javaResource.resourceGroups().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        resourceGroupValueResponseToKotlin(args0)
                    }),
                )
            }).toMap()
        })

    /**
     * The target subscription scope of the blueprint assignment (format: '/subscriptions/{subscriptionId}'). For management group level assignments, the property is required.
     */
    public val scope: Output<String>?
        get() = javaResource.scope().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Status of blueprint assignment. This field is readonly.
     */
    public val status: Output<AssignmentStatusResponse>
        get() = javaResource.status().applyValue({ args0 ->
            args0.let({ args0 ->
                assignmentStatusResponseToKotlin(args0)
            })
        })

    /**
     * Type of this resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object AssignmentMapper : ResourceMapper<Assignment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.blueprint.Assignment::class == javaResource::class

    override fun map(javaResource: Resource): Assignment = Assignment(
        javaResource as
            com.pulumi.azurenative.blueprint.Assignment,
    )
}

/**
 * @see [Assignment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Assignment].
 */
public suspend fun assignment(name: String, block: suspend AssignmentResourceBuilder.() -> Unit): Assignment {
    val builder = AssignmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Assignment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun assignment(name: String): Assignment {
    val builder = AssignmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
