@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.blueprint.kotlin

import com.pulumi.azurenative.blueprint.kotlin.outputs.BlueprintStatusResponse
import com.pulumi.azurenative.blueprint.kotlin.outputs.ParameterDefinitionResponse
import com.pulumi.azurenative.blueprint.kotlin.outputs.ResourceGroupDefinitionResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.blueprint.kotlin.outputs.BlueprintStatusResponse.Companion.toKotlin as blueprintStatusResponseToKotlin
import com.pulumi.azurenative.blueprint.kotlin.outputs.ParameterDefinitionResponse.Companion.toKotlin as parameterDefinitionResponseToKotlin
import com.pulumi.azurenative.blueprint.kotlin.outputs.ResourceGroupDefinitionResponse.Companion.toKotlin as resourceGroupDefinitionResponseToKotlin

/**
 * Builder for [Blueprint].
 */
@PulumiTagMarker
public class BlueprintResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BlueprintArgs = BlueprintArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BlueprintArgsBuilder.() -> Unit) {
        val builder = BlueprintArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Blueprint {
        val builtJavaResource = com.pulumi.azurenative.blueprint.Blueprint(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Blueprint(builtJavaResource)
    }
}

/**
 * Represents a Blueprint definition.
 * Azure REST API version: 2018-11-01-preview. Prior API version in Azure Native 1.x: 2018-11-01-preview.
 * Other available API versions: 2017-11-11-preview.
 * ## Example Usage
 * ### ManagementGroupBlueprint
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var blueprint = new AzureNative.Blueprint.Blueprint("blueprint", new()
 *     {
 *         BlueprintName = "simpleBlueprint",
 *         Description = "blueprint contains all artifact kinds {'template', 'rbac', 'policy'}",
 *         Parameters =
 *         {
 *             { "costCenter", new AzureNative.Blueprint.Inputs.ParameterDefinitionArgs
 *             {
 *                 DisplayName = "force cost center tag for all resources under given subscription.",
 *                 Type = AzureNative.Blueprint.TemplateParameterType.@String,
 *             } },
 *             { "owners", new AzureNative.Blueprint.Inputs.ParameterDefinitionArgs
 *             {
 *                 DisplayName = "assign owners to subscription along with blueprint assignment.",
 *                 Type = AzureNative.Blueprint.TemplateParameterType.Array,
 *             } },
 *             { "storageAccountType", new AzureNative.Blueprint.Inputs.ParameterDefinitionArgs
 *             {
 *                 DisplayName = "storage account type.",
 *                 Type = AzureNative.Blueprint.TemplateParameterType.@String,
 *             } },
 *         },
 *         ResourceGroups =
 *         {
 *             { "storageRG", new AzureNative.Blueprint.Inputs.ResourceGroupDefinitionArgs
 *             {
 *                 Description = "Contains storageAccounts that collect all shoebox logs.",
 *                 DisplayName = "storage resource group",
 *             } },
 *         },
 *         ResourceScope = "providers/Microsoft.Management/managementGroups/ContosoOnlineGroup",
 *         TargetScope = AzureNative.Blueprint.BlueprintTargetScope.Subscription,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/blueprint/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := blueprint.NewBlueprint(ctx, "blueprint", &blueprint.BlueprintArgs{
 * 			BlueprintName: pulumi.String("simpleBlueprint"),
 * 			Description:   pulumi.String("blueprint contains all artifact kinds {'template', 'rbac', 'policy'}"),
 * 			Parameters: blueprint.ParameterDefinitionMap{
 * 				"costCenter": &blueprint.ParameterDefinitionArgs{
 * 					DisplayName: pulumi.String("force cost center tag for all resources under given subscription."),
 * 					Type:        pulumi.String(blueprint.TemplateParameterTypeString),
 * 				},
 * 				"owners": &blueprint.ParameterDefinitionArgs{
 * 					DisplayName: pulumi.String("assign owners to subscription along with blueprint assignment."),
 * 					Type:        pulumi.String(blueprint.TemplateParameterTypeArray),
 * 				},
 * 				"storageAccountType": &blueprint.ParameterDefinitionArgs{
 * 					DisplayName: pulumi.String("storage account type."),
 * 					Type:        pulumi.String(blueprint.TemplateParameterTypeString),
 * 				},
 * 			},
 * 			ResourceGroups: blueprint.ResourceGroupDefinitionMap{
 * 				"storageRG": &blueprint.ResourceGroupDefinitionArgs{
 * 					Description: pulumi.String("Contains storageAccounts that collect all shoebox logs."),
 * 					DisplayName: pulumi.String("storage resource group"),
 * 				},
 * 			},
 * 			ResourceScope: pulumi.String("providers/Microsoft.Management/managementGroups/ContosoOnlineGroup"),
 * 			TargetScope:   pulumi.String(blueprint.BlueprintTargetScopeSubscription),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.blueprint.Blueprint;
 * import com.pulumi.azurenative.blueprint.BlueprintArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var blueprint = new Blueprint("blueprint", BlueprintArgs.builder()
 *             .blueprintName("simpleBlueprint")
 *             .description("blueprint contains all artifact kinds {'template', 'rbac', 'policy'}")
 *             .parameters(Map.ofEntries(
 *                 Map.entry("costCenter", Map.ofEntries(
 *                     Map.entry("displayName", "force cost center tag for all resources under given subscription."),
 *                     Map.entry("type", "string")
 *                 )),
 *                 Map.entry("owners", Map.ofEntries(
 *                     Map.entry("displayName", "assign owners to subscription along with blueprint assignment."),
 *                     Map.entry("type", "array")
 *                 )),
 *                 Map.entry("storageAccountType", Map.ofEntries(
 *                     Map.entry("displayName", "storage account type."),
 *                     Map.entry("type", "string")
 *                 ))
 *             ))
 *             .resourceGroups(Map.of("storageRG", Map.ofEntries(
 *                 Map.entry("description", "Contains storageAccounts that collect all shoebox logs."),
 *                 Map.entry("displayName", "storage resource group")
 *             )))
 *             .resourceScope("providers/Microsoft.Management/managementGroups/ContosoOnlineGroup")
 *             .targetScope("subscription")
 *             .build());
 *     }
 * }
 * ```
 * ### ResourceGroupWithTags
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var blueprint = new AzureNative.Blueprint.Blueprint("blueprint", new()
 *     {
 *         BlueprintName = "simpleBlueprint",
 *         Description = "An example blueprint containing an RG with two tags.",
 *         ResourceGroups =
 *         {
 *             { "myRGName", new AzureNative.Blueprint.Inputs.ResourceGroupDefinitionArgs
 *             {
 *                 DisplayName = "My Resource Group",
 *                 Location = "westus",
 *                 Name = "myRGName",
 *                 Tags =
 *                 {
 *                     { "costcenter", "123456" },
 *                     { "nameOnlyTag", "" },
 *                 },
 *             } },
 *         },
 *         ResourceScope = "providers/Microsoft.Management/managementGroups/{ManagementGroupId}",
 *         TargetScope = AzureNative.Blueprint.BlueprintTargetScope.Subscription,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/blueprint/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := blueprint.NewBlueprint(ctx, "blueprint", &blueprint.BlueprintArgs{
 * 			BlueprintName: pulumi.String("simpleBlueprint"),
 * 			Description:   pulumi.String("An example blueprint containing an RG with two tags."),
 * 			ResourceGroups: blueprint.ResourceGroupDefinitionMap{
 * 				"myRGName": &blueprint.ResourceGroupDefinitionArgs{
 * 					DisplayName: pulumi.String("My Resource Group"),
 * 					Location:    pulumi.String("westus"),
 * 					Name:        pulumi.String("myRGName"),
 * 					Tags: pulumi.StringMap{
 * 						"costcenter":  pulumi.String("123456"),
 * 						"nameOnlyTag": pulumi.String(""),
 * 					},
 * 				},
 * 			},
 * 			ResourceScope: pulumi.String("providers/Microsoft.Management/managementGroups/{ManagementGroupId}"),
 * 			TargetScope:   pulumi.String(blueprint.BlueprintTargetScopeSubscription),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.blueprint.Blueprint;
 * import com.pulumi.azurenative.blueprint.BlueprintArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var blueprint = new Blueprint("blueprint", BlueprintArgs.builder()
 *             .blueprintName("simpleBlueprint")
 *             .description("An example blueprint containing an RG with two tags.")
 *             .resourceGroups(Map.of("myRGName", Map.ofEntries(
 *                 Map.entry("displayName", "My Resource Group"),
 *                 Map.entry("location", "westus"),
 *                 Map.entry("name", "myRGName"),
 *                 Map.entry("tags", Map.ofEntries(
 *                     Map.entry("costcenter", "123456"),
 *                     Map.entry("nameOnlyTag", "")
 *                 ))
 *             )))
 *             .resourceScope("providers/Microsoft.Management/managementGroups/{ManagementGroupId}")
 *             .targetScope("subscription")
 *             .build());
 *     }
 * }
 * ```
 * ### SubscriptionBlueprint
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var blueprint = new AzureNative.Blueprint.Blueprint("blueprint", new()
 *     {
 *         BlueprintName = "simpleBlueprint",
 *         Description = "blueprint contains all artifact kinds {'template', 'rbac', 'policy'}",
 *         Parameters =
 *         {
 *             { "costCenter", new AzureNative.Blueprint.Inputs.ParameterDefinitionArgs
 *             {
 *                 DisplayName = "force cost center tag for all resources under given subscription.",
 *                 Type = AzureNative.Blueprint.TemplateParameterType.@String,
 *             } },
 *             { "owners", new AzureNative.Blueprint.Inputs.ParameterDefinitionArgs
 *             {
 *                 DisplayName = "assign owners to subscription along with blueprint assignment.",
 *                 Type = AzureNative.Blueprint.TemplateParameterType.Array,
 *             } },
 *             { "storageAccountType", new AzureNative.Blueprint.Inputs.ParameterDefinitionArgs
 *             {
 *                 DisplayName = "storage account type.",
 *                 Type = AzureNative.Blueprint.TemplateParameterType.@String,
 *             } },
 *         },
 *         ResourceGroups =
 *         {
 *             { "storageRG", new AzureNative.Blueprint.Inputs.ResourceGroupDefinitionArgs
 *             {
 *                 Description = "Contains storageAccounts that collect all shoebox logs.",
 *                 DisplayName = "storage resource group",
 *             } },
 *         },
 *         ResourceScope = "subscriptions/00000000-0000-0000-0000-000000000000",
 *         TargetScope = AzureNative.Blueprint.BlueprintTargetScope.Subscription,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/blueprint/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := blueprint.NewBlueprint(ctx, "blueprint", &blueprint.BlueprintArgs{
 * 			BlueprintName: pulumi.String("simpleBlueprint"),
 * 			Description:   pulumi.String("blueprint contains all artifact kinds {'template', 'rbac', 'policy'}"),
 * 			Parameters: blueprint.ParameterDefinitionMap{
 * 				"costCenter": &blueprint.ParameterDefinitionArgs{
 * 					DisplayName: pulumi.String("force cost center tag for all resources under given subscription."),
 * 					Type:        pulumi.String(blueprint.TemplateParameterTypeString),
 * 				},
 * 				"owners": &blueprint.ParameterDefinitionArgs{
 * 					DisplayName: pulumi.String("assign owners to subscription along with blueprint assignment."),
 * 					Type:        pulumi.String(blueprint.TemplateParameterTypeArray),
 * 				},
 * 				"storageAccountType": &blueprint.ParameterDefinitionArgs{
 * 					DisplayName: pulumi.String("storage account type."),
 * 					Type:        pulumi.String(blueprint.TemplateParameterTypeString),
 * 				},
 * 			},
 * 			ResourceGroups: blueprint.ResourceGroupDefinitionMap{
 * 				"storageRG": &blueprint.ResourceGroupDefinitionArgs{
 * 					Description: pulumi.String("Contains storageAccounts that collect all shoebox logs."),
 * 					DisplayName: pulumi.String("storage resource group"),
 * 				},
 * 			},
 * 			ResourceScope: pulumi.String("subscriptions/00000000-0000-0000-0000-000000000000"),
 * 			TargetScope:   pulumi.String(blueprint.BlueprintTargetScopeSubscription),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.blueprint.Blueprint;
 * import com.pulumi.azurenative.blueprint.BlueprintArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var blueprint = new Blueprint("blueprint", BlueprintArgs.builder()
 *             .blueprintName("simpleBlueprint")
 *             .description("blueprint contains all artifact kinds {'template', 'rbac', 'policy'}")
 *             .parameters(Map.ofEntries(
 *                 Map.entry("costCenter", Map.ofEntries(
 *                     Map.entry("displayName", "force cost center tag for all resources under given subscription."),
 *                     Map.entry("type", "string")
 *                 )),
 *                 Map.entry("owners", Map.ofEntries(
 *                     Map.entry("displayName", "assign owners to subscription along with blueprint assignment."),
 *                     Map.entry("type", "array")
 *                 )),
 *                 Map.entry("storageAccountType", Map.ofEntries(
 *                     Map.entry("displayName", "storage account type."),
 *                     Map.entry("type", "string")
 *                 ))
 *             ))
 *             .resourceGroups(Map.of("storageRG", Map.ofEntries(
 *                 Map.entry("description", "Contains storageAccounts that collect all shoebox logs."),
 *                 Map.entry("displayName", "storage resource group")
 *             )))
 *             .resourceScope("subscriptions/00000000-0000-0000-0000-000000000000")
 *             .targetScope("subscription")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:blueprint:Blueprint simpleBlueprint /{resourceScope}/providers/Microsoft.Blueprint/blueprints/{blueprintName}
 * ```
 */
public class Blueprint internal constructor(
    override val javaResource: com.pulumi.azurenative.blueprint.Blueprint,
) : KotlinCustomResource(javaResource, BlueprintMapper) {
    /**
     * Multi-line explain this resource.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * One-liner string explain this resource.
     */
    public val displayName: Output<String>?
        get() = javaResource.displayName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Layout view of the blueprint definition for UI reference.
     */
    public val layout: Output<Any>
        get() = javaResource.layout().applyValue({ args0 -> args0 })

    /**
     * Name of this resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Parameters required by this blueprint definition.
     */
    public val parameters: Output<Map<String, ParameterDefinitionResponse>>?
        get() = javaResource.parameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(
                        args0.value.let({ args0 ->
                            parameterDefinitionResponseToKotlin(args0)
                        }),
                    )
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource group placeholders defined by this blueprint definition.
     */
    public val resourceGroups: Output<Map<String, ResourceGroupDefinitionResponse>>?
        get() = javaResource.resourceGroups().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(
                        args0.value.let({ args0 ->
                            resourceGroupDefinitionResponseToKotlin(args0)
                        }),
                    )
                }).toMap()
            }).orElse(null)
        })

    /**
     * Status of the blueprint. This field is readonly.
     */
    public val status: Output<BlueprintStatusResponse>
        get() = javaResource.status().applyValue({ args0 ->
            args0.let({ args0 ->
                blueprintStatusResponseToKotlin(args0)
            })
        })

    /**
     * The scope where this blueprint definition can be assigned.
     */
    public val targetScope: Output<String>
        get() = javaResource.targetScope().applyValue({ args0 -> args0 })

    /**
     * Type of this resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Published versions of this blueprint definition.
     */
    public val versions: Output<Any>?
        get() = javaResource.versions().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object BlueprintMapper : ResourceMapper<Blueprint> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.blueprint.Blueprint::class == javaResource::class

    override fun map(javaResource: Resource): Blueprint = Blueprint(
        javaResource as
            com.pulumi.azurenative.blueprint.Blueprint,
    )
}

/**
 * @see [Blueprint].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Blueprint].
 */
public suspend fun blueprint(name: String, block: suspend BlueprintResourceBuilder.() -> Unit): Blueprint {
    val builder = BlueprintResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Blueprint].
 * @param name The _unique_ name of the resulting resource.
 */
public fun blueprint(name: String): Blueprint {
    val builder = BlueprintResourceBuilder()
    builder.name(name)
    return builder.build()
}
