@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.blueprint.kotlin

import com.pulumi.azurenative.blueprint.PublishedBlueprintArgs.builder
import com.pulumi.azurenative.blueprint.kotlin.enums.BlueprintTargetScope
import com.pulumi.azurenative.blueprint.kotlin.inputs.ParameterDefinitionArgs
import com.pulumi.azurenative.blueprint.kotlin.inputs.ParameterDefinitionArgsBuilder
import com.pulumi.azurenative.blueprint.kotlin.inputs.ResourceGroupDefinitionArgs
import com.pulumi.azurenative.blueprint.kotlin.inputs.ResourceGroupDefinitionArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Represents a published blueprint.
 * Azure REST API version: 2018-11-01-preview. Prior API version in Azure Native 1.x: 2018-11-01-preview.
 * Other available API versions: 2017-11-11-preview.
 * ## Example Usage
 * ### PublishedManagementGroupBlueprint_Publish
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var publishedBlueprint = new AzureNative.Blueprint.PublishedBlueprint("publishedBlueprint", new()
 *     {
 *         BlueprintName = "simpleBlueprint",
 *         ResourceScope = "providers/Microsoft.Management/managementGroups/ContosoOnlineGroup",
 *         VersionId = "v2",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/blueprint/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := blueprint.NewPublishedBlueprint(ctx, "publishedBlueprint", &blueprint.PublishedBlueprintArgs{
 * 			BlueprintName: pulumi.String("simpleBlueprint"),
 * 			ResourceScope: pulumi.String("providers/Microsoft.Management/managementGroups/ContosoOnlineGroup"),
 * 			VersionId:     pulumi.String("v2"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.blueprint.PublishedBlueprint;
 * import com.pulumi.azurenative.blueprint.PublishedBlueprintArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var publishedBlueprint = new PublishedBlueprint("publishedBlueprint", PublishedBlueprintArgs.builder()
 *             .blueprintName("simpleBlueprint")
 *             .resourceScope("providers/Microsoft.Management/managementGroups/ContosoOnlineGroup")
 *             .versionId("v2")
 *             .build());
 *     }
 * }
 * ```
 * ### PublishedSubscriptionBlueprint_Publish
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var publishedBlueprint = new AzureNative.Blueprint.PublishedBlueprint("publishedBlueprint", new()
 *     {
 *         BlueprintName = "simpleBlueprint",
 *         ResourceScope = "subscriptions/00000000-0000-0000-0000-000000000000",
 *         VersionId = "v2",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/blueprint/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := blueprint.NewPublishedBlueprint(ctx, "publishedBlueprint", &blueprint.PublishedBlueprintArgs{
 * 			BlueprintName: pulumi.String("simpleBlueprint"),
 * 			ResourceScope: pulumi.String("subscriptions/00000000-0000-0000-0000-000000000000"),
 * 			VersionId:     pulumi.String("v2"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.blueprint.PublishedBlueprint;
 * import com.pulumi.azurenative.blueprint.PublishedBlueprintArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var publishedBlueprint = new PublishedBlueprint("publishedBlueprint", PublishedBlueprintArgs.builder()
 *             .blueprintName("simpleBlueprint")
 *             .resourceScope("subscriptions/00000000-0000-0000-0000-000000000000")
 *             .versionId("v2")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:blueprint:PublishedBlueprint v2 /{resourceScope}/providers/Microsoft.Blueprint/blueprints/{blueprintName}/versions/{versionId}
 * ```
 * @property blueprintName Name of the published blueprint definition.
 * @property changeNotes Version-specific change notes.
 * @property description Multi-line explain this resource.
 * @property displayName One-liner string explain this resource.
 * @property parameters Parameters required by this blueprint definition.
 * @property resourceGroups Resource group placeholders defined by this blueprint definition.
 * @property resourceScope The scope of the resource. Valid scopes are: management group (format: '/providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription (format: '/subscriptions/{subscriptionId}').
 * @property targetScope The scope where this blueprint definition can be assigned.
 * @property versionId Version of the published blueprint definition.
 */
public data class PublishedBlueprintArgs(
    public val blueprintName: Output<String>? = null,
    public val changeNotes: Output<String>? = null,
    public val description: Output<String>? = null,
    public val displayName: Output<String>? = null,
    public val parameters: Output<Map<String, ParameterDefinitionArgs>>? = null,
    public val resourceGroups: Output<Map<String, ResourceGroupDefinitionArgs>>? = null,
    public val resourceScope: Output<String>? = null,
    public val targetScope: Output<Either<String, BlueprintTargetScope>>? = null,
    public val versionId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.blueprint.PublishedBlueprintArgs> {
    override fun toJava(): com.pulumi.azurenative.blueprint.PublishedBlueprintArgs =
        com.pulumi.azurenative.blueprint.PublishedBlueprintArgs.builder()
            .blueprintName(blueprintName?.applyValue({ args0 -> args0 }))
            .changeNotes(changeNotes?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .resourceGroups(
                resourceGroups?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .resourceScope(resourceScope?.applyValue({ args0 -> args0 }))
            .targetScope(
                targetScope?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .versionId(versionId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PublishedBlueprintArgs].
 */
@PulumiTagMarker
public class PublishedBlueprintArgsBuilder internal constructor() {
    private var blueprintName: Output<String>? = null

    private var changeNotes: Output<String>? = null

    private var description: Output<String>? = null

    private var displayName: Output<String>? = null

    private var parameters: Output<Map<String, ParameterDefinitionArgs>>? = null

    private var resourceGroups: Output<Map<String, ResourceGroupDefinitionArgs>>? = null

    private var resourceScope: Output<String>? = null

    private var targetScope: Output<Either<String, BlueprintTargetScope>>? = null

    private var versionId: Output<String>? = null

    /**
     * @param value Name of the published blueprint definition.
     */
    @JvmName("qonyyhuhjerghccn")
    public suspend fun blueprintName(`value`: Output<String>) {
        this.blueprintName = value
    }

    /**
     * @param value Version-specific change notes.
     */
    @JvmName("aehffpydjogkwfvq")
    public suspend fun changeNotes(`value`: Output<String>) {
        this.changeNotes = value
    }

    /**
     * @param value Multi-line explain this resource.
     */
    @JvmName("syiatjosqsoyrvur")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value One-liner string explain this resource.
     */
    @JvmName("yfuiulfgrhutpgab")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value Parameters required by this blueprint definition.
     */
    @JvmName("bqwayljplivnqriw")
    public suspend fun parameters(`value`: Output<Map<String, ParameterDefinitionArgs>>) {
        this.parameters = value
    }

    /**
     * @param value Resource group placeholders defined by this blueprint definition.
     */
    @JvmName("vmgvwsemhvpwvynx")
    public suspend fun resourceGroups(`value`: Output<Map<String, ResourceGroupDefinitionArgs>>) {
        this.resourceGroups = value
    }

    /**
     * @param value The scope of the resource. Valid scopes are: management group (format: '/providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription (format: '/subscriptions/{subscriptionId}').
     */
    @JvmName("tmpxpmivcdyqgvdy")
    public suspend fun resourceScope(`value`: Output<String>) {
        this.resourceScope = value
    }

    /**
     * @param value The scope where this blueprint definition can be assigned.
     */
    @JvmName("eeifnwinvtxdbhey")
    public suspend fun targetScope(`value`: Output<Either<String, BlueprintTargetScope>>) {
        this.targetScope = value
    }

    /**
     * @param value Version of the published blueprint definition.
     */
    @JvmName("mwrjxhoooqabvsmx")
    public suspend fun versionId(`value`: Output<String>) {
        this.versionId = value
    }

    /**
     * @param value Name of the published blueprint definition.
     */
    @JvmName("vecidweburfbfaxf")
    public suspend fun blueprintName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.blueprintName = mapped
    }

    /**
     * @param value Version-specific change notes.
     */
    @JvmName("ljnwbvudfcyljwgq")
    public suspend fun changeNotes(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.changeNotes = mapped
    }

    /**
     * @param value Multi-line explain this resource.
     */
    @JvmName("hlrkhpffeigsfmrx")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value One-liner string explain this resource.
     */
    @JvmName("dutvqxpoapwvfhyg")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value Parameters required by this blueprint definition.
     */
    @JvmName("eadrcqprognalaja")
    public suspend fun parameters(`value`: Map<String, ParameterDefinitionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Parameters required by this blueprint definition.
     */
    @JvmName("nunvyjkbpnbvkbrv")
    public suspend fun parameters(vararg argument: Pair<String, suspend ParameterDefinitionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                ParameterDefinitionArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values Parameters required by this blueprint definition.
     */
    @JvmName("bynbktusxmwdygdm")
    public fun parameters(vararg values: Pair<String, ParameterDefinitionArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value Resource group placeholders defined by this blueprint definition.
     */
    @JvmName("usaqcootxsjyktlo")
    public suspend fun resourceGroups(`value`: Map<String, ResourceGroupDefinitionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroups = mapped
    }

    /**
     * @param argument Resource group placeholders defined by this blueprint definition.
     */
    @JvmName("fmibduhfkfpklste")
    public suspend fun resourceGroups(vararg argument: Pair<String, suspend ResourceGroupDefinitionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                ResourceGroupDefinitionArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.resourceGroups = mapped
    }

    /**
     * @param values Resource group placeholders defined by this blueprint definition.
     */
    @JvmName("eumyfdkgmlwwuewb")
    public fun resourceGroups(vararg values: Pair<String, ResourceGroupDefinitionArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceGroups = mapped
    }

    /**
     * @param value The scope of the resource. Valid scopes are: management group (format: '/providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription (format: '/subscriptions/{subscriptionId}').
     */
    @JvmName("xexubrcckeokvuan")
    public suspend fun resourceScope(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceScope = mapped
    }

    /**
     * @param value The scope where this blueprint definition can be assigned.
     */
    @JvmName("rbqxshurlryscsvu")
    public suspend fun targetScope(`value`: Either<String, BlueprintTargetScope>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetScope = mapped
    }

    /**
     * @param value The scope where this blueprint definition can be assigned.
     */
    @JvmName("ftrfntqwxacuydjr")
    public fun targetScope(`value`: String) {
        val toBeMapped = Either.ofLeft<String, BlueprintTargetScope>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetScope = mapped
    }

    /**
     * @param value The scope where this blueprint definition can be assigned.
     */
    @JvmName("bflxalfbfpvuxpwj")
    public fun targetScope(`value`: BlueprintTargetScope) {
        val toBeMapped = Either.ofRight<String, BlueprintTargetScope>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetScope = mapped
    }

    /**
     * @param value Version of the published blueprint definition.
     */
    @JvmName("ckljhhmwetnhwyyu")
    public suspend fun versionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.versionId = mapped
    }

    internal fun build(): PublishedBlueprintArgs = PublishedBlueprintArgs(
        blueprintName = blueprintName,
        changeNotes = changeNotes,
        description = description,
        displayName = displayName,
        parameters = parameters,
        resourceGroups = resourceGroups,
        resourceScope = resourceScope,
        targetScope = targetScope,
        versionId = versionId,
    )
}
