@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.blueprint.kotlin

import com.pulumi.azurenative.blueprint.RoleAssignmentArtifactArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Blueprint artifact that applies a Role assignment.
 * Azure REST API version: 2018-11-01-preview. Prior API version in Azure Native 1.x: 2018-11-01-preview.
 * ## Example Usage
 * ### MG-ARMTemplateArtifact
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var roleAssignmentArtifact = new AzureNative.Blueprint.RoleAssignmentArtifact("roleAssignmentArtifact", new()
 *     {
 *         ArtifactName = "storageTemplate",
 *         BlueprintName = "simpleBlueprint",
 *         ResourceScope = "providers/Microsoft.Management/managementGroups/ContosoOnlineGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/blueprint/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := blueprint.NewRoleAssignmentArtifact(ctx, "roleAssignmentArtifact", &blueprint.RoleAssignmentArtifactArgs{
 * 			ArtifactName:  pulumi.String("storageTemplate"),
 * 			BlueprintName: pulumi.String("simpleBlueprint"),
 * 			ResourceScope: pulumi.String("providers/Microsoft.Management/managementGroups/ContosoOnlineGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.blueprint.RoleAssignmentArtifact;
 * import com.pulumi.azurenative.blueprint.RoleAssignmentArtifactArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var roleAssignmentArtifact = new RoleAssignmentArtifact("roleAssignmentArtifact", RoleAssignmentArtifactArgs.builder()
 *             .artifactName("storageTemplate")
 *             .blueprintName("simpleBlueprint")
 *             .resourceScope("providers/Microsoft.Management/managementGroups/ContosoOnlineGroup")
 *             .build());
 *     }
 * }
 * ```
 * ### MG-PolicyAssignmentArtifact
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var roleAssignmentArtifact = new AzureNative.Blueprint.RoleAssignmentArtifact("roleAssignmentArtifact", new()
 *     {
 *         ArtifactName = "costCenterPolicy",
 *         BlueprintName = "simpleBlueprint",
 *         ResourceScope = "providers/Microsoft.Management/managementGroups/ContosoOnlineGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/blueprint/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := blueprint.NewRoleAssignmentArtifact(ctx, "roleAssignmentArtifact", &blueprint.RoleAssignmentArtifactArgs{
 * 			ArtifactName:  pulumi.String("costCenterPolicy"),
 * 			BlueprintName: pulumi.String("simpleBlueprint"),
 * 			ResourceScope: pulumi.String("providers/Microsoft.Management/managementGroups/ContosoOnlineGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.blueprint.RoleAssignmentArtifact;
 * import com.pulumi.azurenative.blueprint.RoleAssignmentArtifactArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var roleAssignmentArtifact = new RoleAssignmentArtifact("roleAssignmentArtifact", RoleAssignmentArtifactArgs.builder()
 *             .artifactName("costCenterPolicy")
 *             .blueprintName("simpleBlueprint")
 *             .resourceScope("providers/Microsoft.Management/managementGroups/ContosoOnlineGroup")
 *             .build());
 *     }
 * }
 * ```
 * ### MG-RoleAssignmentArtifact
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var roleAssignmentArtifact = new AzureNative.Blueprint.RoleAssignmentArtifact("roleAssignmentArtifact", new()
 *     {
 *         ArtifactName = "ownerAssignment",
 *         BlueprintName = "simpleBlueprint",
 *         DisplayName = "enforce owners of given subscription",
 *         Kind = "roleAssignment",
 *         PrincipalIds = "[parameters('owners')]",
 *         ResourceScope = "providers/Microsoft.Management/managementGroups/ContosoOnlineGroup",
 *         RoleDefinitionId = "/providers/Microsoft.Authorization/roleDefinitions/acdd72a7-3385-48ef-bd42-f606fba81ae7",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/blueprint/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := blueprint.NewRoleAssignmentArtifact(ctx, "roleAssignmentArtifact", &blueprint.RoleAssignmentArtifactArgs{
 * 			ArtifactName:     pulumi.String("ownerAssignment"),
 * 			BlueprintName:    pulumi.String("simpleBlueprint"),
 * 			DisplayName:      pulumi.String("enforce owners of given subscription"),
 * 			Kind:             pulumi.String("roleAssignment"),
 * 			PrincipalIds:     pulumi.Any("[parameters('owners')]"),
 * 			ResourceScope:    pulumi.String("providers/Microsoft.Management/managementGroups/ContosoOnlineGroup"),
 * 			RoleDefinitionId: pulumi.String("/providers/Microsoft.Authorization/roleDefinitions/acdd72a7-3385-48ef-bd42-f606fba81ae7"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.blueprint.RoleAssignmentArtifact;
 * import com.pulumi.azurenative.blueprint.RoleAssignmentArtifactArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var roleAssignmentArtifact = new RoleAssignmentArtifact("roleAssignmentArtifact", RoleAssignmentArtifactArgs.builder()
 *             .artifactName("ownerAssignment")
 *             .blueprintName("simpleBlueprint")
 *             .displayName("enforce owners of given subscription")
 *             .kind("roleAssignment")
 *             .principalIds("[parameters('owners')]")
 *             .resourceScope("providers/Microsoft.Management/managementGroups/ContosoOnlineGroup")
 *             .roleDefinitionId("/providers/Microsoft.Authorization/roleDefinitions/acdd72a7-3385-48ef-bd42-f606fba81ae7")
 *             .build());
 *     }
 * }
 * ```
 * ### Sub-ARMTemplateArtifact
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var roleAssignmentArtifact = new AzureNative.Blueprint.RoleAssignmentArtifact("roleAssignmentArtifact", new()
 *     {
 *         ArtifactName = "storageTemplate",
 *         BlueprintName = "simpleBlueprint",
 *         ResourceScope = "subscriptions/00000000-0000-0000-0000-000000000000",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/blueprint/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := blueprint.NewRoleAssignmentArtifact(ctx, "roleAssignmentArtifact", &blueprint.RoleAssignmentArtifactArgs{
 * 			ArtifactName:  pulumi.String("storageTemplate"),
 * 			BlueprintName: pulumi.String("simpleBlueprint"),
 * 			ResourceScope: pulumi.String("subscriptions/00000000-0000-0000-0000-000000000000"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.blueprint.RoleAssignmentArtifact;
 * import com.pulumi.azurenative.blueprint.RoleAssignmentArtifactArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var roleAssignmentArtifact = new RoleAssignmentArtifact("roleAssignmentArtifact", RoleAssignmentArtifactArgs.builder()
 *             .artifactName("storageTemplate")
 *             .blueprintName("simpleBlueprint")
 *             .resourceScope("subscriptions/00000000-0000-0000-0000-000000000000")
 *             .build());
 *     }
 * }
 * ```
 * ### Sub-PolicyAssignmentArtifact
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var roleAssignmentArtifact = new AzureNative.Blueprint.RoleAssignmentArtifact("roleAssignmentArtifact", new()
 *     {
 *         ArtifactName = "costCenterPolicy",
 *         BlueprintName = "simpleBlueprint",
 *         ResourceScope = "subscriptions/00000000-0000-0000-0000-000000000000",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/blueprint/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := blueprint.NewRoleAssignmentArtifact(ctx, "roleAssignmentArtifact", &blueprint.RoleAssignmentArtifactArgs{
 * 			ArtifactName:  pulumi.String("costCenterPolicy"),
 * 			BlueprintName: pulumi.String("simpleBlueprint"),
 * 			ResourceScope: pulumi.String("subscriptions/00000000-0000-0000-0000-000000000000"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.blueprint.RoleAssignmentArtifact;
 * import com.pulumi.azurenative.blueprint.RoleAssignmentArtifactArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var roleAssignmentArtifact = new RoleAssignmentArtifact("roleAssignmentArtifact", RoleAssignmentArtifactArgs.builder()
 *             .artifactName("costCenterPolicy")
 *             .blueprintName("simpleBlueprint")
 *             .resourceScope("subscriptions/00000000-0000-0000-0000-000000000000")
 *             .build());
 *     }
 * }
 * ```
 * ### Sub-RoleAssignmentArtifact
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var roleAssignmentArtifact = new AzureNative.Blueprint.RoleAssignmentArtifact("roleAssignmentArtifact", new()
 *     {
 *         ArtifactName = "ownerAssignment",
 *         BlueprintName = "simpleBlueprint",
 *         DisplayName = "enforce owners of given subscription",
 *         Kind = "roleAssignment",
 *         PrincipalIds = "[parameters('owners')]",
 *         ResourceScope = "subscriptions/00000000-0000-0000-0000-000000000000",
 *         RoleDefinitionId = "/providers/Microsoft.Authorization/roleDefinitions/acdd72a7-3385-48ef-bd42-f606fba81ae7",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/blueprint/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := blueprint.NewRoleAssignmentArtifact(ctx, "roleAssignmentArtifact", &blueprint.RoleAssignmentArtifactArgs{
 * 			ArtifactName:     pulumi.String("ownerAssignment"),
 * 			BlueprintName:    pulumi.String("simpleBlueprint"),
 * 			DisplayName:      pulumi.String("enforce owners of given subscription"),
 * 			Kind:             pulumi.String("roleAssignment"),
 * 			PrincipalIds:     pulumi.Any("[parameters('owners')]"),
 * 			ResourceScope:    pulumi.String("subscriptions/00000000-0000-0000-0000-000000000000"),
 * 			RoleDefinitionId: pulumi.String("/providers/Microsoft.Authorization/roleDefinitions/acdd72a7-3385-48ef-bd42-f606fba81ae7"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.blueprint.RoleAssignmentArtifact;
 * import com.pulumi.azurenative.blueprint.RoleAssignmentArtifactArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var roleAssignmentArtifact = new RoleAssignmentArtifact("roleAssignmentArtifact", RoleAssignmentArtifactArgs.builder()
 *             .artifactName("ownerAssignment")
 *             .blueprintName("simpleBlueprint")
 *             .displayName("enforce owners of given subscription")
 *             .kind("roleAssignment")
 *             .principalIds("[parameters('owners')]")
 *             .resourceScope("subscriptions/00000000-0000-0000-0000-000000000000")
 *             .roleDefinitionId("/providers/Microsoft.Authorization/roleDefinitions/acdd72a7-3385-48ef-bd42-f606fba81ae7")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:blueprint:RoleAssignmentArtifact ownerAssignment /{resourceScope}/providers/Microsoft.Blueprint/blueprints/{blueprintName}/artifacts/{artifactName}
 * ```
 * @property artifactName Name of the blueprint artifact.
 * @property blueprintName Name of the blueprint definition.
 * @property dependsOn Artifacts which need to be deployed before the specified artifact.
 * @property description Multi-line explain this resource.
 * @property displayName One-liner string explain this resource.
 * @property kind Specifies the kind of blueprint artifact.
 * Expected value is 'roleAssignment'.
 * @property principalIds Array of user or group identities in Azure Active Directory. The roleDefinition will apply to each identity.
 * @property resourceGroup RoleAssignment will be scope to this resourceGroup. If empty, it scopes to the subscription.
 * @property resourceScope The scope of the resource. Valid scopes are: management group (format: '/providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription (format: '/subscriptions/{subscriptionId}').
 * @property roleDefinitionId Azure resource ID of the RoleDefinition.
 */
public data class RoleAssignmentArtifactArgs(
    public val artifactName: Output<String>? = null,
    public val blueprintName: Output<String>? = null,
    public val dependsOn: Output<List<String>>? = null,
    public val description: Output<String>? = null,
    public val displayName: Output<String>? = null,
    public val kind: Output<String>? = null,
    public val principalIds: Output<Any>? = null,
    public val resourceGroup: Output<String>? = null,
    public val resourceScope: Output<String>? = null,
    public val roleDefinitionId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.blueprint.RoleAssignmentArtifactArgs> {
    override fun toJava(): com.pulumi.azurenative.blueprint.RoleAssignmentArtifactArgs =
        com.pulumi.azurenative.blueprint.RoleAssignmentArtifactArgs.builder()
            .artifactName(artifactName?.applyValue({ args0 -> args0 }))
            .blueprintName(blueprintName?.applyValue({ args0 -> args0 }))
            .dependsOn(dependsOn?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .principalIds(principalIds?.applyValue({ args0 -> args0 }))
            .resourceGroup(resourceGroup?.applyValue({ args0 -> args0 }))
            .resourceScope(resourceScope?.applyValue({ args0 -> args0 }))
            .roleDefinitionId(roleDefinitionId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RoleAssignmentArtifactArgs].
 */
@PulumiTagMarker
public class RoleAssignmentArtifactArgsBuilder internal constructor() {
    private var artifactName: Output<String>? = null

    private var blueprintName: Output<String>? = null

    private var dependsOn: Output<List<String>>? = null

    private var description: Output<String>? = null

    private var displayName: Output<String>? = null

    private var kind: Output<String>? = null

    private var principalIds: Output<Any>? = null

    private var resourceGroup: Output<String>? = null

    private var resourceScope: Output<String>? = null

    private var roleDefinitionId: Output<String>? = null

    /**
     * @param value Name of the blueprint artifact.
     */
    @JvmName("wosokcmyceenlgaj")
    public suspend fun artifactName(`value`: Output<String>) {
        this.artifactName = value
    }

    /**
     * @param value Name of the blueprint definition.
     */
    @JvmName("tngdfrctlfbojygs")
    public suspend fun blueprintName(`value`: Output<String>) {
        this.blueprintName = value
    }

    /**
     * @param value Artifacts which need to be deployed before the specified artifact.
     */
    @JvmName("qxjjrbyctosoqxxi")
    public suspend fun dependsOn(`value`: Output<List<String>>) {
        this.dependsOn = value
    }

    @JvmName("xeqtbfrlackwyitf")
    public suspend fun dependsOn(vararg values: Output<String>) {
        this.dependsOn = Output.all(values.asList())
    }

    /**
     * @param values Artifacts which need to be deployed before the specified artifact.
     */
    @JvmName("eyjnlmgmpvrtibss")
    public suspend fun dependsOn(values: List<Output<String>>) {
        this.dependsOn = Output.all(values)
    }

    /**
     * @param value Multi-line explain this resource.
     */
    @JvmName("shvyxpldwlbaalaa")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value One-liner string explain this resource.
     */
    @JvmName("xrxxppxysowpclgu")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value Specifies the kind of blueprint artifact.
     * Expected value is 'roleAssignment'.
     */
    @JvmName("vhougoiqheyorujc")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value Array of user or group identities in Azure Active Directory. The roleDefinition will apply to each identity.
     */
    @JvmName("iyaftytvapeiutkf")
    public suspend fun principalIds(`value`: Output<Any>) {
        this.principalIds = value
    }

    /**
     * @param value RoleAssignment will be scope to this resourceGroup. If empty, it scopes to the subscription.
     */
    @JvmName("rprjrnjonabkgndr")
    public suspend fun resourceGroup(`value`: Output<String>) {
        this.resourceGroup = value
    }

    /**
     * @param value The scope of the resource. Valid scopes are: management group (format: '/providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription (format: '/subscriptions/{subscriptionId}').
     */
    @JvmName("yvldymhjhcyuayug")
    public suspend fun resourceScope(`value`: Output<String>) {
        this.resourceScope = value
    }

    /**
     * @param value Azure resource ID of the RoleDefinition.
     */
    @JvmName("rcqfpcqswvgownqh")
    public suspend fun roleDefinitionId(`value`: Output<String>) {
        this.roleDefinitionId = value
    }

    /**
     * @param value Name of the blueprint artifact.
     */
    @JvmName("lwcurxheyjetdnrc")
    public suspend fun artifactName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.artifactName = mapped
    }

    /**
     * @param value Name of the blueprint definition.
     */
    @JvmName("jpnttbvseadsrmug")
    public suspend fun blueprintName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.blueprintName = mapped
    }

    /**
     * @param value Artifacts which need to be deployed before the specified artifact.
     */
    @JvmName("eocrsbsgxeiboivk")
    public suspend fun dependsOn(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dependsOn = mapped
    }

    /**
     * @param values Artifacts which need to be deployed before the specified artifact.
     */
    @JvmName("ruutbkrcyvdjpuyn")
    public suspend fun dependsOn(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dependsOn = mapped
    }

    /**
     * @param value Multi-line explain this resource.
     */
    @JvmName("kcwlhnlsrebjgaij")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value One-liner string explain this resource.
     */
    @JvmName("okhnrtyboqdosphg")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value Specifies the kind of blueprint artifact.
     * Expected value is 'roleAssignment'.
     */
    @JvmName("ocixolnumrljsocc")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Array of user or group identities in Azure Active Directory. The roleDefinition will apply to each identity.
     */
    @JvmName("enjatvakhsjnhxsq")
    public suspend fun principalIds(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.principalIds = mapped
    }

    /**
     * @param value RoleAssignment will be scope to this resourceGroup. If empty, it scopes to the subscription.
     */
    @JvmName("gmwjfolxrcydxgfg")
    public suspend fun resourceGroup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroup = mapped
    }

    /**
     * @param value The scope of the resource. Valid scopes are: management group (format: '/providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription (format: '/subscriptions/{subscriptionId}').
     */
    @JvmName("bxxrfpcjcrlskvis")
    public suspend fun resourceScope(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceScope = mapped
    }

    /**
     * @param value Azure resource ID of the RoleDefinition.
     */
    @JvmName("vcsgttdvfgifmlla")
    public suspend fun roleDefinitionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleDefinitionId = mapped
    }

    internal fun build(): RoleAssignmentArtifactArgs = RoleAssignmentArtifactArgs(
        artifactName = artifactName,
        blueprintName = blueprintName,
        dependsOn = dependsOn,
        description = description,
        displayName = displayName,
        kind = kind,
        principalIds = principalIds,
        resourceGroup = resourceGroup,
        resourceScope = resourceScope,
        roleDefinitionId = roleDefinitionId,
    )
}
