@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.blueprint.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Allowed data types for Resource Manager template parameters.
 */
public enum class TemplateParameterType(
    public val javaValue: com.pulumi.azurenative.blueprint.enums.TemplateParameterType,
) : ConvertibleToJava<com.pulumi.azurenative.blueprint.enums.TemplateParameterType> {
    String(com.pulumi.azurenative.blueprint.enums.TemplateParameterType.String),
    Array(com.pulumi.azurenative.blueprint.enums.TemplateParameterType.Array),
    Bool(com.pulumi.azurenative.blueprint.enums.TemplateParameterType.Bool),
    Int_(com.pulumi.azurenative.blueprint.enums.TemplateParameterType.Int_),
    Object(com.pulumi.azurenative.blueprint.enums.TemplateParameterType.Object),
    SecureObject(com.pulumi.azurenative.blueprint.enums.TemplateParameterType.SecureObject),
    SecureString(com.pulumi.azurenative.blueprint.enums.TemplateParameterType.SecureString),
    ;

    override fun toJava(): com.pulumi.azurenative.blueprint.enums.TemplateParameterType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.blueprint.enums.TemplateParameterType): TemplateParameterType = TemplateParameterType.values().first { it.javaValue == javaType }
    }
}
