@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.blueprint.kotlin.inputs

import com.pulumi.azurenative.blueprint.inputs.GetAssignmentPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property assignmentName Name of the blueprint assignment.
 * @property resourceScope The scope of the resource. Valid scopes are: management group (format: '/providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription (format: '/subscriptions/{subscriptionId}').
 */
public data class GetAssignmentPlainArgs(
    public val assignmentName: String,
    public val resourceScope: String,
) : ConvertibleToJava<com.pulumi.azurenative.blueprint.inputs.GetAssignmentPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.blueprint.inputs.GetAssignmentPlainArgs =
        com.pulumi.azurenative.blueprint.inputs.GetAssignmentPlainArgs.builder()
            .assignmentName(assignmentName.let({ args0 -> args0 }))
            .resourceScope(resourceScope.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAssignmentPlainArgs].
 */
@PulumiTagMarker
public class GetAssignmentPlainArgsBuilder internal constructor() {
    private var assignmentName: String? = null

    private var resourceScope: String? = null

    /**
     * @param value Name of the blueprint assignment.
     */
    @JvmName("axjeciooenwhweek")
    public suspend fun assignmentName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.assignmentName = mapped
    }

    /**
     * @param value The scope of the resource. Valid scopes are: management group (format: '/providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription (format: '/subscriptions/{subscriptionId}').
     */
    @JvmName("hjejckncncopeyny")
    public suspend fun resourceScope(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceScope = mapped
    }

    internal fun build(): GetAssignmentPlainArgs = GetAssignmentPlainArgs(
        assignmentName = assignmentName ?: throw PulumiNullFieldException("assignmentName"),
        resourceScope = resourceScope ?: throw PulumiNullFieldException("resourceScope"),
    )
}
