@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.blueprint.kotlin.inputs

import com.pulumi.azurenative.blueprint.inputs.GetPublishedBlueprintPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property blueprintName Name of the blueprint definition.
 * @property resourceScope The scope of the resource. Valid scopes are: management group (format: '/providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription (format: '/subscriptions/{subscriptionId}').
 * @property versionId Version of the published blueprint definition.
 */
public data class GetPublishedBlueprintPlainArgs(
    public val blueprintName: String,
    public val resourceScope: String,
    public val versionId: String,
) : ConvertibleToJava<com.pulumi.azurenative.blueprint.inputs.GetPublishedBlueprintPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.blueprint.inputs.GetPublishedBlueprintPlainArgs =
        com.pulumi.azurenative.blueprint.inputs.GetPublishedBlueprintPlainArgs.builder()
            .blueprintName(blueprintName.let({ args0 -> args0 }))
            .resourceScope(resourceScope.let({ args0 -> args0 }))
            .versionId(versionId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPublishedBlueprintPlainArgs].
 */
@PulumiTagMarker
public class GetPublishedBlueprintPlainArgsBuilder internal constructor() {
    private var blueprintName: String? = null

    private var resourceScope: String? = null

    private var versionId: String? = null

    /**
     * @param value Name of the blueprint definition.
     */
    @JvmName("asejgkpbyblrbgso")
    public suspend fun blueprintName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.blueprintName = mapped
    }

    /**
     * @param value The scope of the resource. Valid scopes are: management group (format: '/providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription (format: '/subscriptions/{subscriptionId}').
     */
    @JvmName("qkslefcqvjffmaxx")
    public suspend fun resourceScope(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceScope = mapped
    }

    /**
     * @param value Version of the published blueprint definition.
     */
    @JvmName("jmglftanxvgpidiu")
    public suspend fun versionId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.versionId = mapped
    }

    internal fun build(): GetPublishedBlueprintPlainArgs = GetPublishedBlueprintPlainArgs(
        blueprintName = blueprintName ?: throw PulumiNullFieldException("blueprintName"),
        resourceScope = resourceScope ?: throw PulumiNullFieldException("resourceScope"),
        versionId = versionId ?: throw PulumiNullFieldException("versionId"),
    )
}
