@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.blueprint.kotlin.inputs

import com.pulumi.azurenative.blueprint.inputs.KeyVaultReferenceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Specifies the link to a Key Vault.
 * @property id Azure resource ID of the Key Vault.
 */
public data class KeyVaultReferenceArgs(
    public val id: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.blueprint.inputs.KeyVaultReferenceArgs> {
    override fun toJava(): com.pulumi.azurenative.blueprint.inputs.KeyVaultReferenceArgs =
        com.pulumi.azurenative.blueprint.inputs.KeyVaultReferenceArgs.builder()
            .id(id.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [KeyVaultReferenceArgs].
 */
@PulumiTagMarker
public class KeyVaultReferenceArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    /**
     * @param value Azure resource ID of the Key Vault.
     */
    @JvmName("mbfjmkxjekkoxspy")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Azure resource ID of the Key Vault.
     */
    @JvmName("ujflcvlgukmwdcqk")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.id = mapped
    }

    internal fun build(): KeyVaultReferenceArgs = KeyVaultReferenceArgs(
        id = id ?: throw PulumiNullFieldException("id"),
    )
}
