@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.blueprint.kotlin.inputs

import com.pulumi.azurenative.blueprint.inputs.ParameterValueArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Value for the specified parameter. Can be either 'value' or 'reference' but not both.
 * @property reference Parameter value as reference type.
 * @property value Parameter value. Any valid JSON value is allowed including objects, arrays, strings, numbers and booleans.
 */
public data class ParameterValueArgs(
    public val reference: Output<SecretValueReferenceArgs>? = null,
    public val `value`: Output<Any>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.blueprint.inputs.ParameterValueArgs> {
    override fun toJava(): com.pulumi.azurenative.blueprint.inputs.ParameterValueArgs =
        com.pulumi.azurenative.blueprint.inputs.ParameterValueArgs.builder()
            .reference(reference?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ParameterValueArgs].
 */
@PulumiTagMarker
public class ParameterValueArgsBuilder internal constructor() {
    private var reference: Output<SecretValueReferenceArgs>? = null

    private var `value`: Output<Any>? = null

    /**
     * @param value Parameter value as reference type.
     */
    @JvmName("srdavdvrrualwnhe")
    public suspend fun reference(`value`: Output<SecretValueReferenceArgs>) {
        this.reference = value
    }

    /**
     * @param value Parameter value. Any valid JSON value is allowed including objects, arrays, strings, numbers and booleans.
     */
    @JvmName("ttfmiuyuqwldsdmq")
    public suspend fun `value`(`value`: Output<Any>) {
        this.`value` = value
    }

    /**
     * @param value Parameter value as reference type.
     */
    @JvmName("eqhefjbkutwhkgyn")
    public suspend fun reference(`value`: SecretValueReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.reference = mapped
    }

    /**
     * @param argument Parameter value as reference type.
     */
    @JvmName("qxuhhpejfxbpnnwh")
    public suspend fun reference(argument: suspend SecretValueReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = SecretValueReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.reference = mapped
    }

    /**
     * @param value Parameter value. Any valid JSON value is allowed including objects, arrays, strings, numbers and booleans.
     */
    @JvmName("uauhtjlvicoirsdn")
    public suspend fun `value`(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): ParameterValueArgs = ParameterValueArgs(
        reference = reference,
        `value` = `value`,
    )
}
