@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.blueprint.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *  /*
 * Defines how resources deployed by a blueprint assignment are locked.
 * @property excludedActions List of management operations that are excluded from blueprint locks. Up to 200 actions are permitted. If the lock mode is set to 'AllResourcesReadOnly', then the following actions are automatically appended to 'excludedActions': '*/read', 'Microsoft.Network/virtualNetworks/subnets/join/action' and 'Microsoft.Authorization/locks/delete'. If the lock mode is set to 'AllResourcesDoNotDelete', then the following actions are automatically appended to 'excludedActions': 'Microsoft.Authorization/locks/delete'. Duplicate actions will get removed.
 * @property excludedPrincipals List of AAD principals excluded from blueprint locks. Up to 5 principals are permitted.
 * @property mode Lock mode.
 */
public data class AssignmentLockSettingsResponse(
    public val excludedActions: List<String>? = null,
    public val excludedPrincipals: List<String>? = null,
    public val mode: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.blueprint.outputs.AssignmentLockSettingsResponse): AssignmentLockSettingsResponse = AssignmentLockSettingsResponse(
            excludedActions = javaType.excludedActions().map({ args0 -> args0 }),
            excludedPrincipals = javaType.excludedPrincipals().map({ args0 -> args0 }),
            mode = javaType.mode().map({ args0 -> args0 }).orElse(null),
        )
    }
}
