@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.blueprint.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Represents a blueprint assignment.
 * @property blueprintId ID of the published version of a blueprint definition.
 * @property description Multi-line explain this resource.
 * @property displayName One-liner string explain this resource.
 * @property id String Id used to locate any resource on Azure.
 * @property identity Managed identity for this blueprint assignment.
 * @property location The location of this blueprint assignment.
 * @property locks Defines how resources deployed by a blueprint assignment are locked.
 * @property name Name of this resource.
 * @property parameters Blueprint assignment parameter values.
 * @property provisioningState State of the blueprint assignment.
 * @property resourceGroups Names and locations of resource group placeholders.
 * @property scope The target subscription scope of the blueprint assignment (format: '/subscriptions/{subscriptionId}'). For management group level assignments, the property is required.
 * @property status Status of blueprint assignment. This field is readonly.
 * @property type Type of this resource.
 */
public data class GetAssignmentResult(
    public val blueprintId: String? = null,
    public val description: String? = null,
    public val displayName: String? = null,
    public val id: String,
    public val identity: ManagedServiceIdentityResponse,
    public val location: String,
    public val locks: AssignmentLockSettingsResponse? = null,
    public val name: String,
    public val parameters: Map<String, ParameterValueResponse>,
    public val provisioningState: String,
    public val resourceGroups: Map<String, ResourceGroupValueResponse>,
    public val scope: String? = null,
    public val status: AssignmentStatusResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.blueprint.outputs.GetAssignmentResult): GetAssignmentResult = GetAssignmentResult(
            blueprintId = javaType.blueprintId().map({ args0 -> args0 }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            displayName = javaType.displayName().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            identity = javaType.identity().let({ args0 ->
                com.pulumi.azurenative.blueprint.kotlin.outputs.ManagedServiceIdentityResponse.Companion.toKotlin(args0)
            }),
            location = javaType.location(),
            locks = javaType.locks().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.blueprint.kotlin.outputs.AssignmentLockSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            name = javaType.name(),
            parameters = javaType.parameters().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.blueprint.kotlin.outputs.ParameterValueResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            provisioningState = javaType.provisioningState(),
            resourceGroups = javaType.resourceGroups().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.blueprint.kotlin.outputs.ResourceGroupValueResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            scope = javaType.scope().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().let({ args0 ->
                com.pulumi.azurenative.blueprint.kotlin.outputs.AssignmentStatusResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
