@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.blueprint.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Blueprint artifact that applies a Policy assignment.
 * @property dependsOn Artifacts which need to be deployed before the specified artifact.
 * @property description Multi-line explain this resource.
 * @property displayName One-liner string explain this resource.
 * @property id String Id used to locate any resource on Azure.
 * @property kind Specifies the kind of blueprint artifact.
 * Expected value is 'policyAssignment'.
 * @property name Name of this resource.
 * @property parameters Parameter values for the policy definition.
 * @property policyDefinitionId Azure resource ID of the policy definition.
 * @property resourceGroup Name of the resource group placeholder to which the policy will be assigned.
 * @property type Type of this resource.
 */
public data class GetPolicyAssignmentArtifactResult(
    public val dependsOn: List<String>? = null,
    public val description: String? = null,
    public val displayName: String? = null,
    public val id: String,
    public val kind: String,
    public val name: String,
    public val parameters: Map<String, ParameterValueResponse>,
    public val policyDefinitionId: String,
    public val resourceGroup: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.blueprint.outputs.GetPolicyAssignmentArtifactResult): GetPolicyAssignmentArtifactResult = GetPolicyAssignmentArtifactResult(
            dependsOn = javaType.dependsOn().map({ args0 -> args0 }),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            displayName = javaType.displayName().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            kind = javaType.kind(),
            name = javaType.name(),
            parameters = javaType.parameters().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.blueprint.kotlin.outputs.ParameterValueResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            policyDefinitionId = javaType.policyDefinitionId(),
            resourceGroup = javaType.resourceGroup().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
