@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.blueprint.kotlin.outputs

import kotlin.Any
import kotlin.Suppress

/**
 * Value for the specified parameter. Can be either 'value' or 'reference' but not both.
 * @property reference Parameter value as reference type.
 * @property value Parameter value. Any valid JSON value is allowed including objects, arrays, strings, numbers and booleans.
 */
public data class ParameterValueResponse(
    public val reference: SecretValueReferenceResponse? = null,
    public val `value`: Any? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.blueprint.outputs.ParameterValueResponse): ParameterValueResponse = ParameterValueResponse(
            reference = javaType.reference().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.blueprint.kotlin.outputs.SecretValueReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            `value` = javaType.`value`().map({ args0 -> args0 }).orElse(null),
        )
    }
}
