@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.botservice.kotlin

import com.pulumi.azurenative.botservice.kotlin.outputs.ConnectionSettingPropertiesResponse
import com.pulumi.azurenative.botservice.kotlin.outputs.SkuResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.botservice.kotlin.outputs.ConnectionSettingPropertiesResponse.Companion.toKotlin as connectionSettingPropertiesResponseToKotlin
import com.pulumi.azurenative.botservice.kotlin.outputs.SkuResponse.Companion.toKotlin as skuResponseToKotlin

/**
 * Builder for [BotConnection].
 */
@PulumiTagMarker
public class BotConnectionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BotConnectionArgs = BotConnectionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BotConnectionArgsBuilder.() -> Unit) {
        val builder = BotConnectionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): BotConnection {
        val builtJavaResource = com.pulumi.azurenative.botservice.BotConnection(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return BotConnection(builtJavaResource)
    }
}

/**
 * Bot channel resource definition
 * Azure REST API version: 2022-09-15. Prior API version in Azure Native 1.x: 2021-03-01.
 * Other available API versions: 2023-09-15-preview.
 * ## Example Usage
 * ### Create Connection Setting
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var botConnection = new AzureNative.BotService.BotConnection("botConnection", new()
 *     {
 *         ConnectionName = "sampleConnection",
 *         Location = "West US",
 *         Properties = new AzureNative.BotService.Inputs.ConnectionSettingPropertiesArgs
 *         {
 *             ClientId = "sampleclientid",
 *             ClientSecret = "samplesecret",
 *             Parameters = new[]
 *             {
 *                 new AzureNative.BotService.Inputs.ConnectionSettingParameterArgs
 *                 {
 *                     Key = "key1",
 *                     Value = "value1",
 *                 },
 *                 new AzureNative.BotService.Inputs.ConnectionSettingParameterArgs
 *                 {
 *                     Key = "key2",
 *                     Value = "value2",
 *                 },
 *             },
 *             Scopes = "samplescope",
 *             ServiceProviderId = "serviceproviderid",
 *         },
 *         ResourceGroupName = "OneResourceGroupName",
 *         ResourceName = "samplebotname",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/botservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := botservice.NewBotConnection(ctx, "botConnection", &botservice.BotConnectionArgs{
 * 			ConnectionName: pulumi.String("sampleConnection"),
 * 			Location:       pulumi.String("West US"),
 * 			Properties: &botservice.ConnectionSettingPropertiesArgs{
 * 				ClientId:     pulumi.String("sampleclientid"),
 * 				ClientSecret: pulumi.String("samplesecret"),
 * 				Parameters: botservice.ConnectionSettingParameterArray{
 * 					&botservice.ConnectionSettingParameterArgs{
 * 						Key:   pulumi.String("key1"),
 * 						Value: pulumi.String("value1"),
 * 					},
 * 					&botservice.ConnectionSettingParameterArgs{
 * 						Key:   pulumi.String("key2"),
 * 						Value: pulumi.String("value2"),
 * 					},
 * 				},
 * 				Scopes:            pulumi.String("samplescope"),
 * 				ServiceProviderId: pulumi.String("serviceproviderid"),
 * 			},
 * 			ResourceGroupName: pulumi.String("OneResourceGroupName"),
 * 			ResourceName:      pulumi.String("samplebotname"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.botservice.BotConnection;
 * import com.pulumi.azurenative.botservice.BotConnectionArgs;
 * import com.pulumi.azurenative.botservice.inputs.ConnectionSettingPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var botConnection = new BotConnection("botConnection", BotConnectionArgs.builder()
 *             .connectionName("sampleConnection")
 *             .location("West US")
 *             .properties(ConnectionSettingPropertiesArgs.builder()
 *                 .clientId("sampleclientid")
 *                 .clientSecret("samplesecret")
 *                 .parameters(
 *                     ConnectionSettingParameterArgs.builder()
 *                         .key("key1")
 *                         .value("value1")
 *                         .build(),
 *                     ConnectionSettingParameterArgs.builder()
 *                         .key("key2")
 *                         .value("value2")
 *                         .build())
 *                 .scopes("samplescope")
 *                 .serviceProviderId("serviceproviderid")
 *                 .build())
 *             .resourceGroupName("OneResourceGroupName")
 *             .resourceName("samplebotname")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:botservice:BotConnection sampleConnection /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BotService/botServices/{resourceName}/connections/{connectionName}
 * ```
 */
public class BotConnection internal constructor(
    override val javaResource: com.pulumi.azurenative.botservice.BotConnection,
) : KotlinCustomResource(javaResource, BotConnectionMapper) {
    /**
     * Entity Tag.
     */
    public val etag: Output<String>?
        get() = javaResource.etag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Required. Gets or sets the Kind of the resource.
     */
    public val kind: Output<String>?
        get() = javaResource.kind().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Specifies the location of the resource.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Specifies the name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The set of properties specific to bot channel resource
     */
    public val properties: Output<ConnectionSettingPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                connectionSettingPropertiesResponseToKotlin(args0)
            })
        })

    /**
     * Gets or sets the SKU of the resource.
     */
    public val sku: Output<SkuResponse>?
        get() = javaResource.sku().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    skuResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Contains resource tags defined as key/value pairs.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Specifies the type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Entity zones
     */
    public val zones: Output<List<String>>
        get() = javaResource.zones().applyValue({ args0 -> args0.map({ args0 -> args0 }) })
}

public object BotConnectionMapper : ResourceMapper<BotConnection> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.botservice.BotConnection::class == javaResource::class

    override fun map(javaResource: Resource): BotConnection = BotConnection(
        javaResource as
            com.pulumi.azurenative.botservice.BotConnection,
    )
}

/**
 * @see [BotConnection].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [BotConnection].
 */
public suspend fun botConnection(
    name: String,
    block: suspend BotConnectionResourceBuilder.() -> Unit,
): BotConnection {
    val builder = BotConnectionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [BotConnection].
 * @param name The _unique_ name of the resulting resource.
 */
public fun botConnection(name: String): BotConnection {
    val builder = BotConnectionResourceBuilder()
    builder.name(name)
    return builder.build()
}
