@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.botservice.kotlin

import com.pulumi.azurenative.botservice.BotserviceFunctions.getBotConnectionPlain
import com.pulumi.azurenative.botservice.BotserviceFunctions.getBotPlain
import com.pulumi.azurenative.botservice.BotserviceFunctions.getChannelPlain
import com.pulumi.azurenative.botservice.BotserviceFunctions.getPrivateEndpointConnectionPlain
import com.pulumi.azurenative.botservice.BotserviceFunctions.listBotConnectionServiceProvidersPlain
import com.pulumi.azurenative.botservice.BotserviceFunctions.listBotConnectionWithSecretsPlain
import com.pulumi.azurenative.botservice.BotserviceFunctions.listChannelWithKeysPlain
import com.pulumi.azurenative.botservice.BotserviceFunctions.listQnAMakerEndpointKeyPlain
import com.pulumi.azurenative.botservice.kotlin.inputs.GetBotConnectionPlainArgs
import com.pulumi.azurenative.botservice.kotlin.inputs.GetBotConnectionPlainArgsBuilder
import com.pulumi.azurenative.botservice.kotlin.inputs.GetBotPlainArgs
import com.pulumi.azurenative.botservice.kotlin.inputs.GetBotPlainArgsBuilder
import com.pulumi.azurenative.botservice.kotlin.inputs.GetChannelPlainArgs
import com.pulumi.azurenative.botservice.kotlin.inputs.GetChannelPlainArgsBuilder
import com.pulumi.azurenative.botservice.kotlin.inputs.GetPrivateEndpointConnectionPlainArgs
import com.pulumi.azurenative.botservice.kotlin.inputs.GetPrivateEndpointConnectionPlainArgsBuilder
import com.pulumi.azurenative.botservice.kotlin.inputs.ListBotConnectionWithSecretsPlainArgs
import com.pulumi.azurenative.botservice.kotlin.inputs.ListBotConnectionWithSecretsPlainArgsBuilder
import com.pulumi.azurenative.botservice.kotlin.inputs.ListChannelWithKeysPlainArgs
import com.pulumi.azurenative.botservice.kotlin.inputs.ListChannelWithKeysPlainArgsBuilder
import com.pulumi.azurenative.botservice.kotlin.inputs.ListQnAMakerEndpointKeyPlainArgs
import com.pulumi.azurenative.botservice.kotlin.inputs.ListQnAMakerEndpointKeyPlainArgsBuilder
import com.pulumi.azurenative.botservice.kotlin.outputs.GetBotConnectionResult
import com.pulumi.azurenative.botservice.kotlin.outputs.GetBotResult
import com.pulumi.azurenative.botservice.kotlin.outputs.GetChannelResult
import com.pulumi.azurenative.botservice.kotlin.outputs.GetPrivateEndpointConnectionResult
import com.pulumi.azurenative.botservice.kotlin.outputs.ListBotConnectionServiceProvidersResult
import com.pulumi.azurenative.botservice.kotlin.outputs.ListBotConnectionWithSecretsResult
import com.pulumi.azurenative.botservice.kotlin.outputs.ListChannelWithKeysResult
import com.pulumi.azurenative.botservice.kotlin.outputs.ListQnAMakerEndpointKeyResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.botservice.kotlin.outputs.GetBotConnectionResult.Companion.toKotlin as getBotConnectionResultToKotlin
import com.pulumi.azurenative.botservice.kotlin.outputs.GetBotResult.Companion.toKotlin as getBotResultToKotlin
import com.pulumi.azurenative.botservice.kotlin.outputs.GetChannelResult.Companion.toKotlin as getChannelResultToKotlin
import com.pulumi.azurenative.botservice.kotlin.outputs.GetPrivateEndpointConnectionResult.Companion.toKotlin as getPrivateEndpointConnectionResultToKotlin
import com.pulumi.azurenative.botservice.kotlin.outputs.ListBotConnectionServiceProvidersResult.Companion.toKotlin as listBotConnectionServiceProvidersResultToKotlin
import com.pulumi.azurenative.botservice.kotlin.outputs.ListBotConnectionWithSecretsResult.Companion.toKotlin as listBotConnectionWithSecretsResultToKotlin
import com.pulumi.azurenative.botservice.kotlin.outputs.ListChannelWithKeysResult.Companion.toKotlin as listChannelWithKeysResultToKotlin
import com.pulumi.azurenative.botservice.kotlin.outputs.ListQnAMakerEndpointKeyResult.Companion.toKotlin as listQnAMakerEndpointKeyResultToKotlin

public object BotserviceFunctions {
    /**
     * Returns a BotService specified by the parameters.
     * Azure REST API version: 2022-09-15.
     * Other available API versions: 2023-09-15-preview.
     * @param argument null
     * @return Bot resource definition
     */
    public suspend fun getBot(argument: GetBotPlainArgs): GetBotResult =
        getBotResultToKotlin(getBotPlain(argument.toJava()).await())

    /**
     * @see [getBot].
     * @param resourceGroupName The name of the Bot resource group in the user subscription.
     * @param resourceName The name of the Bot resource.
     * @return Bot resource definition
     */
    public suspend fun getBot(resourceGroupName: String, resourceName: String): GetBotResult {
        val argument = GetBotPlainArgs(
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
        )
        return getBotResultToKotlin(getBotPlain(argument.toJava()).await())
    }

    /**
     * @see [getBot].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;botservice&#46;kotlin&#46;inputs&#46;GetBotPlainArgs].
     * @return Bot resource definition
     */
    public suspend fun getBot(argument: suspend GetBotPlainArgsBuilder.() -> Unit): GetBotResult {
        val builder = GetBotPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getBotResultToKotlin(getBotPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a Connection Setting registration for a Bot Service
     * Azure REST API version: 2022-09-15.
     * Other available API versions: 2023-09-15-preview.
     * @param argument null
     * @return Bot channel resource definition
     */
    public suspend fun getBotConnection(argument: GetBotConnectionPlainArgs): GetBotConnectionResult =
        getBotConnectionResultToKotlin(getBotConnectionPlain(argument.toJava()).await())

    /**
     * @see [getBotConnection].
     * @param connectionName The name of the Bot Service Connection Setting resource.
     * @param resourceGroupName The name of the Bot resource group in the user subscription.
     * @param resourceName The name of the Bot resource.
     * @return Bot channel resource definition
     */
    public suspend fun getBotConnection(
        connectionName: String,
        resourceGroupName: String,
        resourceName: String,
    ): GetBotConnectionResult {
        val argument = GetBotConnectionPlainArgs(
            connectionName = connectionName,
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
        )
        return getBotConnectionResultToKotlin(getBotConnectionPlain(argument.toJava()).await())
    }

    /**
     * @see [getBotConnection].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;botservice&#46;kotlin&#46;inputs&#46;GetBotConnectionPlainArgs].
     * @return Bot channel resource definition
     */
    public suspend fun getBotConnection(argument: suspend GetBotConnectionPlainArgsBuilder.() -> Unit): GetBotConnectionResult {
        val builder = GetBotConnectionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getBotConnectionResultToKotlin(getBotConnectionPlain(builtArgument.toJava()).await())
    }

    /**
     * Returns a BotService Channel registration specified by the parameters.
     * Azure REST API version: 2022-09-15.
     * Other available API versions: 2023-09-15-preview.
     * @param argument null
     * @return Bot channel resource definition
     */
    public suspend fun getChannel(argument: GetChannelPlainArgs): GetChannelResult =
        getChannelResultToKotlin(getChannelPlain(argument.toJava()).await())

    /**
     * @see [getChannel].
     * @param channelName The name of the Bot resource.
     * @param resourceGroupName The name of the Bot resource group in the user subscription.
     * @param resourceName The name of the Bot resource.
     * @return Bot channel resource definition
     */
    public suspend fun getChannel(
        channelName: String,
        resourceGroupName: String,
        resourceName: String,
    ): GetChannelResult {
        val argument = GetChannelPlainArgs(
            channelName = channelName,
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
        )
        return getChannelResultToKotlin(getChannelPlain(argument.toJava()).await())
    }

    /**
     * @see [getChannel].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;botservice&#46;kotlin&#46;inputs&#46;GetChannelPlainArgs].
     * @return Bot channel resource definition
     */
    public suspend fun getChannel(argument: suspend GetChannelPlainArgsBuilder.() -> Unit): GetChannelResult {
        val builder = GetChannelPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getChannelResultToKotlin(getChannelPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the specified private endpoint connection associated with the Bot.
     * Azure REST API version: 2022-09-15.
     * Other available API versions: 2023-09-15-preview.
     * @param argument null
     * @return The Private Endpoint Connection resource.
     */
    public suspend fun getPrivateEndpointConnection(argument: GetPrivateEndpointConnectionPlainArgs): GetPrivateEndpointConnectionResult =
        getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(argument.toJava()).await())

    /**
     * @see [getPrivateEndpointConnection].
     * @param privateEndpointConnectionName The name of the private endpoint connection associated with the Azure resource
     * @param resourceGroupName The name of the Bot resource group in the user subscription.
     * @param resourceName The name of the Bot resource.
     * @return The Private Endpoint Connection resource.
     */
    public suspend fun getPrivateEndpointConnection(
        privateEndpointConnectionName: String,
        resourceGroupName: String,
        resourceName: String,
    ): GetPrivateEndpointConnectionResult {
        val argument = GetPrivateEndpointConnectionPlainArgs(
            privateEndpointConnectionName = privateEndpointConnectionName,
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
        )
        return getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(argument.toJava()).await())
    }

    /**
     * @see [getPrivateEndpointConnection].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;botservice&#46;kotlin&#46;inputs&#46;GetPrivateEndpointConnectionPlainArgs].
     * @return The Private Endpoint Connection resource.
     */
    public suspend fun getPrivateEndpointConnection(argument: suspend GetPrivateEndpointConnectionPlainArgsBuilder.() -> Unit): GetPrivateEndpointConnectionResult {
        val builder = GetPrivateEndpointConnectionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(builtArgument.toJava()).await())
    }

    /**
     * Lists the available Service Providers for creating Connection Settings
     * Azure REST API version: 2022-09-15.
     * Other available API versions: 2017-12-01, 2018-07-12, 2020-06-02, 2021-03-01, 2021-05-01-preview, 2022-06-15-preview, 2023-09-15-preview.
     * @param argument null
     * @return The list of bot service providers response.
     */
    public suspend fun listBotConnectionServiceProviders(): ListBotConnectionServiceProvidersResult =
        listBotConnectionServiceProvidersResultToKotlin(listBotConnectionServiceProvidersPlain().await())

    /**
     * Get a Connection Setting registration for a Bot Service
     * Azure REST API version: 2022-09-15.
     * Other available API versions: 2023-09-15-preview.
     * @param argument null
     * @return Bot channel resource definition
     */
    public suspend fun listBotConnectionWithSecrets(argument: ListBotConnectionWithSecretsPlainArgs): ListBotConnectionWithSecretsResult =
        listBotConnectionWithSecretsResultToKotlin(listBotConnectionWithSecretsPlain(argument.toJava()).await())

    /**
     * @see [listBotConnectionWithSecrets].
     * @param connectionName The name of the Bot Service Connection Setting resource.
     * @param resourceGroupName The name of the Bot resource group in the user subscription.
     * @param resourceName The name of the Bot resource.
     * @return Bot channel resource definition
     */
    public suspend fun listBotConnectionWithSecrets(
        connectionName: String,
        resourceGroupName: String,
        resourceName: String,
    ): ListBotConnectionWithSecretsResult {
        val argument = ListBotConnectionWithSecretsPlainArgs(
            connectionName = connectionName,
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
        )
        return listBotConnectionWithSecretsResultToKotlin(listBotConnectionWithSecretsPlain(argument.toJava()).await())
    }

    /**
     * @see [listBotConnectionWithSecrets].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;botservice&#46;kotlin&#46;inputs&#46;ListBotConnectionWithSecretsPlainArgs].
     * @return Bot channel resource definition
     */
    public suspend fun listBotConnectionWithSecrets(argument: suspend ListBotConnectionWithSecretsPlainArgsBuilder.() -> Unit): ListBotConnectionWithSecretsResult {
        val builder = ListBotConnectionWithSecretsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listBotConnectionWithSecretsResultToKotlin(listBotConnectionWithSecretsPlain(builtArgument.toJava()).await())
    }

    /**
     * Lists a Channel registration for a Bot Service including secrets
     * Azure REST API version: 2022-09-15.
     * Other available API versions: 2023-09-15-preview.
     * @param argument null
     * @return The ARM channel of list channel with keys operation response.
     */
    public suspend fun listChannelWithKeys(argument: ListChannelWithKeysPlainArgs): ListChannelWithKeysResult =
        listChannelWithKeysResultToKotlin(listChannelWithKeysPlain(argument.toJava()).await())

    /**
     * @see [listChannelWithKeys].
     * @param channelName The name of the Channel resource.
     * @param resourceGroupName The name of the Bot resource group in the user subscription.
     * @param resourceName The name of the Bot resource.
     * @return The ARM channel of list channel with keys operation response.
     */
    public suspend fun listChannelWithKeys(
        channelName: String,
        resourceGroupName: String,
        resourceName: String,
    ): ListChannelWithKeysResult {
        val argument = ListChannelWithKeysPlainArgs(
            channelName = channelName,
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
        )
        return listChannelWithKeysResultToKotlin(listChannelWithKeysPlain(argument.toJava()).await())
    }

    /**
     * @see [listChannelWithKeys].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;botservice&#46;kotlin&#46;inputs&#46;ListChannelWithKeysPlainArgs].
     * @return The ARM channel of list channel with keys operation response.
     */
    public suspend fun listChannelWithKeys(argument: suspend ListChannelWithKeysPlainArgsBuilder.() -> Unit): ListChannelWithKeysResult {
        val builder = ListChannelWithKeysPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listChannelWithKeysResultToKotlin(listChannelWithKeysPlain(builtArgument.toJava()).await())
    }

    /**
     * Lists the QnA Maker endpoint keys
     * Azure REST API version: 2022-09-15.
     * Other available API versions: 2022-06-15-preview, 2023-09-15-preview.
     * @param argument null
     * @return Schema for EndpointKeys generate/refresh operations.
     */
    public suspend fun listQnAMakerEndpointKey(argument: ListQnAMakerEndpointKeyPlainArgs): ListQnAMakerEndpointKeyResult =
        listQnAMakerEndpointKeyResultToKotlin(listQnAMakerEndpointKeyPlain(argument.toJava()).await())

    /**
     * @see [listQnAMakerEndpointKey].
     * @param authkey Subscription key which provides access to this API.
     * @param hostname the host name of the QnA Maker endpoint
     * @return Schema for EndpointKeys generate/refresh operations.
     */
    public suspend fun listQnAMakerEndpointKey(authkey: String? = null, hostname: String? = null): ListQnAMakerEndpointKeyResult {
        val argument = ListQnAMakerEndpointKeyPlainArgs(
            authkey = authkey,
            hostname = hostname,
        )
        return listQnAMakerEndpointKeyResultToKotlin(listQnAMakerEndpointKeyPlain(argument.toJava()).await())
    }

    /**
     * @see [listQnAMakerEndpointKey].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;botservice&#46;kotlin&#46;inputs&#46;ListQnAMakerEndpointKeyPlainArgs].
     * @return Schema for EndpointKeys generate/refresh operations.
     */
    public suspend fun listQnAMakerEndpointKey(argument: suspend ListQnAMakerEndpointKeyPlainArgsBuilder.() -> Unit): ListQnAMakerEndpointKeyResult {
        val builder = ListQnAMakerEndpointKeyPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listQnAMakerEndpointKeyResultToKotlin(listQnAMakerEndpointKeyPlain(builtArgument.toJava()).await())
    }
}
