@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.botservice.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Required. Gets or sets the Kind of the resource.
 */
public enum class Kind(
    public val javaValue: com.pulumi.azurenative.botservice.enums.Kind,
) : ConvertibleToJava<com.pulumi.azurenative.botservice.enums.Kind> {
    Sdk(com.pulumi.azurenative.botservice.enums.Kind.Sdk),
    Designer(com.pulumi.azurenative.botservice.enums.Kind.Designer),
    Bot(com.pulumi.azurenative.botservice.enums.Kind.Bot),
    Function(com.pulumi.azurenative.botservice.enums.Kind.Function),
    Azurebot(com.pulumi.azurenative.botservice.enums.Kind.Azurebot),
    ;

    override fun toJava(): com.pulumi.azurenative.botservice.enums.Kind = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.botservice.enums.Kind): Kind =
            Kind.values().first { it.javaValue == javaType }
    }
}
