@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.botservice.kotlin.inputs

import com.pulumi.azurenative.botservice.inputs.ConnectionSettingPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Properties for a Connection Setting Item
 * @property clientId Client Id associated with the Connection Setting.
 * @property clientSecret Client Secret associated with the Connection Setting
 * @property id Id of the Connection Setting.
 * @property name Name of the Connection Setting.
 * @property parameters Service Provider Parameters associated with the Connection Setting
 * @property provisioningState Provisioning state of the resource
 * @property scopes Scopes associated with the Connection Setting
 * @property serviceProviderDisplayName Service Provider Display Name associated with the Connection Setting
 * @property serviceProviderId Service Provider Id associated with the Connection Setting
 */
public data class ConnectionSettingPropertiesArgs(
    public val clientId: Output<String>? = null,
    public val clientSecret: Output<String>? = null,
    public val id: Output<String>? = null,
    public val name: Output<String>? = null,
    public val parameters: Output<List<ConnectionSettingParameterArgs>>? = null,
    public val provisioningState: Output<String>? = null,
    public val scopes: Output<String>? = null,
    public val serviceProviderDisplayName: Output<String>? = null,
    public val serviceProviderId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.botservice.inputs.ConnectionSettingPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.botservice.inputs.ConnectionSettingPropertiesArgs =
        com.pulumi.azurenative.botservice.inputs.ConnectionSettingPropertiesArgs.builder()
            .clientId(clientId?.applyValue({ args0 -> args0 }))
            .clientSecret(clientSecret?.applyValue({ args0 -> args0 }))
            .id(id?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .provisioningState(provisioningState?.applyValue({ args0 -> args0 }))
            .scopes(scopes?.applyValue({ args0 -> args0 }))
            .serviceProviderDisplayName(serviceProviderDisplayName?.applyValue({ args0 -> args0 }))
            .serviceProviderId(serviceProviderId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConnectionSettingPropertiesArgs].
 */
@PulumiTagMarker
public class ConnectionSettingPropertiesArgsBuilder internal constructor() {
    private var clientId: Output<String>? = null

    private var clientSecret: Output<String>? = null

    private var id: Output<String>? = null

    private var name: Output<String>? = null

    private var parameters: Output<List<ConnectionSettingParameterArgs>>? = null

    private var provisioningState: Output<String>? = null

    private var scopes: Output<String>? = null

    private var serviceProviderDisplayName: Output<String>? = null

    private var serviceProviderId: Output<String>? = null

    /**
     * @param value Client Id associated with the Connection Setting.
     */
    @JvmName("qlhsypmalianlabj")
    public suspend fun clientId(`value`: Output<String>) {
        this.clientId = value
    }

    /**
     * @param value Client Secret associated with the Connection Setting
     */
    @JvmName("jdyxlbbyxhehyvud")
    public suspend fun clientSecret(`value`: Output<String>) {
        this.clientSecret = value
    }

    /**
     * @param value Id of the Connection Setting.
     */
    @JvmName("gxdxwdxollubnelc")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Name of the Connection Setting.
     */
    @JvmName("kssrqdllhbxaklrh")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Service Provider Parameters associated with the Connection Setting
     */
    @JvmName("qqcvboyoxqoxopxs")
    public suspend fun parameters(`value`: Output<List<ConnectionSettingParameterArgs>>) {
        this.parameters = value
    }

    @JvmName("qseknxkhtsvshxbn")
    public suspend fun parameters(vararg values: Output<ConnectionSettingParameterArgs>) {
        this.parameters = Output.all(values.asList())
    }

    /**
     * @param values Service Provider Parameters associated with the Connection Setting
     */
    @JvmName("ejrtcnpkhjvmwqln")
    public suspend fun parameters(values: List<Output<ConnectionSettingParameterArgs>>) {
        this.parameters = Output.all(values)
    }

    /**
     * @param value Provisioning state of the resource
     */
    @JvmName("wdmxwpvoeykhlffr")
    public suspend fun provisioningState(`value`: Output<String>) {
        this.provisioningState = value
    }

    /**
     * @param value Scopes associated with the Connection Setting
     */
    @JvmName("aalxlgdpsljskgbk")
    public suspend fun scopes(`value`: Output<String>) {
        this.scopes = value
    }

    /**
     * @param value Service Provider Display Name associated with the Connection Setting
     */
    @JvmName("syapmnyrbobxixnf")
    public suspend fun serviceProviderDisplayName(`value`: Output<String>) {
        this.serviceProviderDisplayName = value
    }

    /**
     * @param value Service Provider Id associated with the Connection Setting
     */
    @JvmName("ovtpkdewjsiqaalx")
    public suspend fun serviceProviderId(`value`: Output<String>) {
        this.serviceProviderId = value
    }

    /**
     * @param value Client Id associated with the Connection Setting.
     */
    @JvmName("xfohwuqyifddtmcl")
    public suspend fun clientId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientId = mapped
    }

    /**
     * @param value Client Secret associated with the Connection Setting
     */
    @JvmName("vcxblrtqlrlighut")
    public suspend fun clientSecret(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientSecret = mapped
    }

    /**
     * @param value Id of the Connection Setting.
     */
    @JvmName("tqukgnvwwkhhwfad")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Name of the Connection Setting.
     */
    @JvmName("xsuvglyxkarjtxeo")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Service Provider Parameters associated with the Connection Setting
     */
    @JvmName("damenjylbltbqrng")
    public suspend fun parameters(`value`: List<ConnectionSettingParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Service Provider Parameters associated with the Connection Setting
     */
    @JvmName("awytohpqlypdeshx")
    public suspend fun parameters(argument: List<suspend ConnectionSettingParameterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ConnectionSettingParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument Service Provider Parameters associated with the Connection Setting
     */
    @JvmName("qeudkvpvniimunsb")
    public suspend fun parameters(vararg argument: suspend ConnectionSettingParameterArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ConnectionSettingParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument Service Provider Parameters associated with the Connection Setting
     */
    @JvmName("gjqllblucjsulexr")
    public suspend fun parameters(argument: suspend ConnectionSettingParameterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ConnectionSettingParameterArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values Service Provider Parameters associated with the Connection Setting
     */
    @JvmName("iwqtkdagbxcwefep")
    public suspend fun parameters(vararg values: ConnectionSettingParameterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value Provisioning state of the resource
     */
    @JvmName("beltelbuwkusivfb")
    public suspend fun provisioningState(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value Scopes associated with the Connection Setting
     */
    @JvmName("qvlwckvxdgbwtncw")
    public suspend fun scopes(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scopes = mapped
    }

    /**
     * @param value Service Provider Display Name associated with the Connection Setting
     */
    @JvmName("bggijxcnhtaelchn")
    public suspend fun serviceProviderDisplayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceProviderDisplayName = mapped
    }

    /**
     * @param value Service Provider Id associated with the Connection Setting
     */
    @JvmName("cflamgcbyfcqltna")
    public suspend fun serviceProviderId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceProviderId = mapped
    }

    internal fun build(): ConnectionSettingPropertiesArgs = ConnectionSettingPropertiesArgs(
        clientId = clientId,
        clientSecret = clientSecret,
        id = id,
        name = name,
        parameters = parameters,
        provisioningState = provisioningState,
        scopes = scopes,
        serviceProviderDisplayName = serviceProviderDisplayName,
        serviceProviderId = serviceProviderId,
    )
}
