@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.botservice.kotlin.inputs

import com.pulumi.azurenative.botservice.inputs.DirectLineSpeechChannelPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The parameters to provide for the DirectLine Speech channel.
 * @property cognitiveServiceRegion The cognitive service region with this channel registration.
 * @property cognitiveServiceResourceId The cognitive service id with this channel registration.
 * @property cognitiveServiceSubscriptionKey The cognitive service subscription key to use with this channel registration.
 * @property customSpeechModelId Custom voice deployment id (optional).
 * @property customVoiceDeploymentId Custom speech model id (optional).
 * @property isDefaultBotForCogSvcAccount Make this a default bot for chosen cognitive service account.
 * @property isEnabled Whether this channel is enabled or not.
 */
public data class DirectLineSpeechChannelPropertiesArgs(
    public val cognitiveServiceRegion: Output<String>? = null,
    public val cognitiveServiceResourceId: Output<String>? = null,
    public val cognitiveServiceSubscriptionKey: Output<String>? = null,
    public val customSpeechModelId: Output<String>? = null,
    public val customVoiceDeploymentId: Output<String>? = null,
    public val isDefaultBotForCogSvcAccount: Output<Boolean>? = null,
    public val isEnabled: Output<Boolean>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.botservice.inputs.DirectLineSpeechChannelPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.botservice.inputs.DirectLineSpeechChannelPropertiesArgs =
        com.pulumi.azurenative.botservice.inputs.DirectLineSpeechChannelPropertiesArgs.builder()
            .cognitiveServiceRegion(cognitiveServiceRegion?.applyValue({ args0 -> args0 }))
            .cognitiveServiceResourceId(cognitiveServiceResourceId?.applyValue({ args0 -> args0 }))
            .cognitiveServiceSubscriptionKey(cognitiveServiceSubscriptionKey?.applyValue({ args0 -> args0 }))
            .customSpeechModelId(customSpeechModelId?.applyValue({ args0 -> args0 }))
            .customVoiceDeploymentId(customVoiceDeploymentId?.applyValue({ args0 -> args0 }))
            .isDefaultBotForCogSvcAccount(isDefaultBotForCogSvcAccount?.applyValue({ args0 -> args0 }))
            .isEnabled(isEnabled?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DirectLineSpeechChannelPropertiesArgs].
 */
@PulumiTagMarker
public class DirectLineSpeechChannelPropertiesArgsBuilder internal constructor() {
    private var cognitiveServiceRegion: Output<String>? = null

    private var cognitiveServiceResourceId: Output<String>? = null

    private var cognitiveServiceSubscriptionKey: Output<String>? = null

    private var customSpeechModelId: Output<String>? = null

    private var customVoiceDeploymentId: Output<String>? = null

    private var isDefaultBotForCogSvcAccount: Output<Boolean>? = null

    private var isEnabled: Output<Boolean>? = null

    /**
     * @param value The cognitive service region with this channel registration.
     */
    @JvmName("euakwlfsncejwirs")
    public suspend fun cognitiveServiceRegion(`value`: Output<String>) {
        this.cognitiveServiceRegion = value
    }

    /**
     * @param value The cognitive service id with this channel registration.
     */
    @JvmName("fchovubouxwsugaq")
    public suspend fun cognitiveServiceResourceId(`value`: Output<String>) {
        this.cognitiveServiceResourceId = value
    }

    /**
     * @param value The cognitive service subscription key to use with this channel registration.
     */
    @JvmName("kbnvmsiyjjhwivjn")
    public suspend fun cognitiveServiceSubscriptionKey(`value`: Output<String>) {
        this.cognitiveServiceSubscriptionKey = value
    }

    /**
     * @param value Custom voice deployment id (optional).
     */
    @JvmName("pruidxupkdiqlkxe")
    public suspend fun customSpeechModelId(`value`: Output<String>) {
        this.customSpeechModelId = value
    }

    /**
     * @param value Custom speech model id (optional).
     */
    @JvmName("screblvadwwcbtyg")
    public suspend fun customVoiceDeploymentId(`value`: Output<String>) {
        this.customVoiceDeploymentId = value
    }

    /**
     * @param value Make this a default bot for chosen cognitive service account.
     */
    @JvmName("rbwtbxeqvtqkphjv")
    public suspend fun isDefaultBotForCogSvcAccount(`value`: Output<Boolean>) {
        this.isDefaultBotForCogSvcAccount = value
    }

    /**
     * @param value Whether this channel is enabled or not.
     */
    @JvmName("gbpkifitebitewbp")
    public suspend fun isEnabled(`value`: Output<Boolean>) {
        this.isEnabled = value
    }

    /**
     * @param value The cognitive service region with this channel registration.
     */
    @JvmName("exgwdjnuaidukmfw")
    public suspend fun cognitiveServiceRegion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cognitiveServiceRegion = mapped
    }

    /**
     * @param value The cognitive service id with this channel registration.
     */
    @JvmName("bjdqtiuqvcveffbi")
    public suspend fun cognitiveServiceResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cognitiveServiceResourceId = mapped
    }

    /**
     * @param value The cognitive service subscription key to use with this channel registration.
     */
    @JvmName("bptsiiwfnkcbsdxa")
    public suspend fun cognitiveServiceSubscriptionKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cognitiveServiceSubscriptionKey = mapped
    }

    /**
     * @param value Custom voice deployment id (optional).
     */
    @JvmName("agkssybibdxkaavm")
    public suspend fun customSpeechModelId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customSpeechModelId = mapped
    }

    /**
     * @param value Custom speech model id (optional).
     */
    @JvmName("eeevkwjelkqirmfu")
    public suspend fun customVoiceDeploymentId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customVoiceDeploymentId = mapped
    }

    /**
     * @param value Make this a default bot for chosen cognitive service account.
     */
    @JvmName("dywoxbuflmdntqkw")
    public suspend fun isDefaultBotForCogSvcAccount(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isDefaultBotForCogSvcAccount = mapped
    }

    /**
     * @param value Whether this channel is enabled or not.
     */
    @JvmName("rkewedqyorxujqin")
    public suspend fun isEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isEnabled = mapped
    }

    internal fun build(): DirectLineSpeechChannelPropertiesArgs =
        DirectLineSpeechChannelPropertiesArgs(
            cognitiveServiceRegion = cognitiveServiceRegion,
            cognitiveServiceResourceId = cognitiveServiceResourceId,
            cognitiveServiceSubscriptionKey = cognitiveServiceSubscriptionKey,
            customSpeechModelId = customSpeechModelId,
            customVoiceDeploymentId = customVoiceDeploymentId,
            isDefaultBotForCogSvcAccount = isDefaultBotForCogSvcAccount,
            isEnabled = isEnabled,
        )
}
