@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.botservice.kotlin.inputs

import com.pulumi.azurenative.botservice.inputs.EmailChannelPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The parameters to provide for the Email channel.
 * @property authMethod Email channel auth method. 0 Password (Default); 1 Graph.
 * @property emailAddress The email address
 * @property isEnabled Whether this channel is enabled for the bot
 * @property magicCode The magic code for setting up the modern authentication.
 * @property password The password for the email address. Value only returned through POST to the action Channel List API, otherwise empty.
 */
public data class EmailChannelPropertiesArgs(
    public val authMethod: Output<Double>? = null,
    public val emailAddress: Output<String>,
    public val isEnabled: Output<Boolean>,
    public val magicCode: Output<String>? = null,
    public val password: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.botservice.inputs.EmailChannelPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.botservice.inputs.EmailChannelPropertiesArgs =
        com.pulumi.azurenative.botservice.inputs.EmailChannelPropertiesArgs.builder()
            .authMethod(authMethod?.applyValue({ args0 -> args0 }))
            .emailAddress(emailAddress.applyValue({ args0 -> args0 }))
            .isEnabled(isEnabled.applyValue({ args0 -> args0 }))
            .magicCode(magicCode?.applyValue({ args0 -> args0 }))
            .password(password?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EmailChannelPropertiesArgs].
 */
@PulumiTagMarker
public class EmailChannelPropertiesArgsBuilder internal constructor() {
    private var authMethod: Output<Double>? = null

    private var emailAddress: Output<String>? = null

    private var isEnabled: Output<Boolean>? = null

    private var magicCode: Output<String>? = null

    private var password: Output<String>? = null

    /**
     * @param value Email channel auth method. 0 Password (Default); 1 Graph.
     */
    @JvmName("wcjflawjxlmovnfv")
    public suspend fun authMethod(`value`: Output<Double>) {
        this.authMethod = value
    }

    /**
     * @param value The email address
     */
    @JvmName("rjwsxwxdrquvodpl")
    public suspend fun emailAddress(`value`: Output<String>) {
        this.emailAddress = value
    }

    /**
     * @param value Whether this channel is enabled for the bot
     */
    @JvmName("tqiaoukukqelkmpg")
    public suspend fun isEnabled(`value`: Output<Boolean>) {
        this.isEnabled = value
    }

    /**
     * @param value The magic code for setting up the modern authentication.
     */
    @JvmName("najginpyvylqtbwu")
    public suspend fun magicCode(`value`: Output<String>) {
        this.magicCode = value
    }

    /**
     * @param value The password for the email address. Value only returned through POST to the action Channel List API, otherwise empty.
     */
    @JvmName("cuguvwakhuvlxcty")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value Email channel auth method. 0 Password (Default); 1 Graph.
     */
    @JvmName("xpoasnikoakpbnvi")
    public suspend fun authMethod(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authMethod = mapped
    }

    /**
     * @param value The email address
     */
    @JvmName("ruvmkubrphukbbqf")
    public suspend fun emailAddress(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.emailAddress = mapped
    }

    /**
     * @param value Whether this channel is enabled for the bot
     */
    @JvmName("kpaenanwnknfcink")
    public suspend fun isEnabled(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.isEnabled = mapped
    }

    /**
     * @param value The magic code for setting up the modern authentication.
     */
    @JvmName("vmqpbeqjnmvbxucs")
    public suspend fun magicCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.magicCode = mapped
    }

    /**
     * @param value The password for the email address. Value only returned through POST to the action Channel List API, otherwise empty.
     */
    @JvmName("cwaghvihuhxgmbxt")
    public suspend fun password(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    internal fun build(): EmailChannelPropertiesArgs = EmailChannelPropertiesArgs(
        authMethod = authMethod,
        emailAddress = emailAddress ?: throw PulumiNullFieldException("emailAddress"),
        isEnabled = isEnabled ?: throw PulumiNullFieldException("isEnabled"),
        magicCode = magicCode,
        password = password,
    )
}
