@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.botservice.kotlin.inputs

import com.pulumi.azurenative.botservice.inputs.FacebookChannelArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Facebook channel definition
 * @property channelName The channel name
 * Expected value is 'FacebookChannel'.
 * @property etag Entity Tag of the resource
 * @property location Specifies the location of the resource.
 * @property properties The set of properties specific to bot facebook channel
 */
public data class FacebookChannelArgs(
    public val channelName: Output<String>,
    public val etag: Output<String>? = null,
    public val location: Output<String>? = null,
    public val properties: Output<FacebookChannelPropertiesArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.botservice.inputs.FacebookChannelArgs> {
    override fun toJava(): com.pulumi.azurenative.botservice.inputs.FacebookChannelArgs =
        com.pulumi.azurenative.botservice.inputs.FacebookChannelArgs.builder()
            .channelName(channelName.applyValue({ args0 -> args0 }))
            .etag(etag?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [FacebookChannelArgs].
 */
@PulumiTagMarker
public class FacebookChannelArgsBuilder internal constructor() {
    private var channelName: Output<String>? = null

    private var etag: Output<String>? = null

    private var location: Output<String>? = null

    private var properties: Output<FacebookChannelPropertiesArgs>? = null

    /**
     * @param value The channel name
     * Expected value is 'FacebookChannel'.
     */
    @JvmName("sdjlopnwbjrwmwjy")
    public suspend fun channelName(`value`: Output<String>) {
        this.channelName = value
    }

    /**
     * @param value Entity Tag of the resource
     */
    @JvmName("oknoywrdixpvvbck")
    public suspend fun etag(`value`: Output<String>) {
        this.etag = value
    }

    /**
     * @param value Specifies the location of the resource.
     */
    @JvmName("hdvkbntrelfdgptg")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The set of properties specific to bot facebook channel
     */
    @JvmName("xarvvjjltbrpfbrf")
    public suspend fun properties(`value`: Output<FacebookChannelPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The channel name
     * Expected value is 'FacebookChannel'.
     */
    @JvmName("kpefksajhvxmxhni")
    public suspend fun channelName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.channelName = mapped
    }

    /**
     * @param value Entity Tag of the resource
     */
    @JvmName("plarjhksaprkmcdy")
    public suspend fun etag(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.etag = mapped
    }

    /**
     * @param value Specifies the location of the resource.
     */
    @JvmName("jmqhtrvjyypktvem")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The set of properties specific to bot facebook channel
     */
    @JvmName("nirksjlmlabayoiv")
    public suspend fun properties(`value`: FacebookChannelPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument The set of properties specific to bot facebook channel
     */
    @JvmName("tkfdgugrpacbwswk")
    public suspend fun properties(argument: suspend FacebookChannelPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = FacebookChannelPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    internal fun build(): FacebookChannelArgs = FacebookChannelArgs(
        channelName = channelName ?: throw PulumiNullFieldException("channelName"),
        etag = etag,
        location = location,
        properties = properties,
    )
}
