@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.botservice.kotlin.inputs

import com.pulumi.azurenative.botservice.inputs.KikChannelPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The parameters to provide for the Kik channel.
 * @property apiKey Kik API key. Value only returned through POST to the action Channel List API, otherwise empty.
 * @property isEnabled Whether this channel is enabled for the bot
 * @property isValidated Whether this channel is validated for the bot
 * @property userName The Kik user name
 */
public data class KikChannelPropertiesArgs(
    public val apiKey: Output<String>? = null,
    public val isEnabled: Output<Boolean>,
    public val isValidated: Output<Boolean>? = null,
    public val userName: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.botservice.inputs.KikChannelPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.botservice.inputs.KikChannelPropertiesArgs =
        com.pulumi.azurenative.botservice.inputs.KikChannelPropertiesArgs.builder()
            .apiKey(apiKey?.applyValue({ args0 -> args0 }))
            .isEnabled(isEnabled.applyValue({ args0 -> args0 }))
            .isValidated(isValidated?.applyValue({ args0 -> args0 }))
            .userName(userName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [KikChannelPropertiesArgs].
 */
@PulumiTagMarker
public class KikChannelPropertiesArgsBuilder internal constructor() {
    private var apiKey: Output<String>? = null

    private var isEnabled: Output<Boolean>? = null

    private var isValidated: Output<Boolean>? = null

    private var userName: Output<String>? = null

    /**
     * @param value Kik API key. Value only returned through POST to the action Channel List API, otherwise empty.
     */
    @JvmName("xtpnqwwqxdkmjfxs")
    public suspend fun apiKey(`value`: Output<String>) {
        this.apiKey = value
    }

    /**
     * @param value Whether this channel is enabled for the bot
     */
    @JvmName("lenpwfpxehbvybsp")
    public suspend fun isEnabled(`value`: Output<Boolean>) {
        this.isEnabled = value
    }

    /**
     * @param value Whether this channel is validated for the bot
     */
    @JvmName("rhkuoqtrhvgpgdgy")
    public suspend fun isValidated(`value`: Output<Boolean>) {
        this.isValidated = value
    }

    /**
     * @param value The Kik user name
     */
    @JvmName("vregjydkpadasckm")
    public suspend fun userName(`value`: Output<String>) {
        this.userName = value
    }

    /**
     * @param value Kik API key. Value only returned through POST to the action Channel List API, otherwise empty.
     */
    @JvmName("vjiswoserikdelhv")
    public suspend fun apiKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiKey = mapped
    }

    /**
     * @param value Whether this channel is enabled for the bot
     */
    @JvmName("tsexocvrmfgsvdij")
    public suspend fun isEnabled(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.isEnabled = mapped
    }

    /**
     * @param value Whether this channel is validated for the bot
     */
    @JvmName("phkwculeonqskovk")
    public suspend fun isValidated(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isValidated = mapped
    }

    /**
     * @param value The Kik user name
     */
    @JvmName("mqmivbhpissudphn")
    public suspend fun userName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userName = mapped
    }

    internal fun build(): KikChannelPropertiesArgs = KikChannelPropertiesArgs(
        apiKey = apiKey,
        isEnabled = isEnabled ?: throw PulumiNullFieldException("isEnabled"),
        isValidated = isValidated,
        userName = userName ?: throw PulumiNullFieldException("userName"),
    )
}
