@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.botservice.kotlin.inputs

import com.pulumi.azurenative.botservice.inputs.TelephonyChannelPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The parameters to provide for the Direct Line channel.
 * @property apiConfigurations The list of Telephony api configuration
 * @property cognitiveServiceRegion The extensionKey2
 * @property cognitiveServiceSubscriptionKey The extensionKey1
 * @property defaultLocale The default locale of the channel
 * @property isEnabled Whether the channel is enabled
 * @property phoneNumbers The list of Telephony phone numbers
 * @property premiumSKU The premium SKU applied to the channel
 */
public data class TelephonyChannelPropertiesArgs(
    public val apiConfigurations: Output<List<TelephonyChannelResourceApiConfigurationArgs>>? = null,
    public val cognitiveServiceRegion: Output<String>? = null,
    public val cognitiveServiceSubscriptionKey: Output<String>? = null,
    public val defaultLocale: Output<String>? = null,
    public val isEnabled: Output<Boolean>? = null,
    public val phoneNumbers: Output<List<TelephonyPhoneNumbersArgs>>? = null,
    public val premiumSKU: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.botservice.inputs.TelephonyChannelPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.botservice.inputs.TelephonyChannelPropertiesArgs =
        com.pulumi.azurenative.botservice.inputs.TelephonyChannelPropertiesArgs.builder()
            .apiConfigurations(
                apiConfigurations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .cognitiveServiceRegion(cognitiveServiceRegion?.applyValue({ args0 -> args0 }))
            .cognitiveServiceSubscriptionKey(cognitiveServiceSubscriptionKey?.applyValue({ args0 -> args0 }))
            .defaultLocale(defaultLocale?.applyValue({ args0 -> args0 }))
            .isEnabled(isEnabled?.applyValue({ args0 -> args0 }))
            .phoneNumbers(
                phoneNumbers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .premiumSKU(premiumSKU?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TelephonyChannelPropertiesArgs].
 */
@PulumiTagMarker
public class TelephonyChannelPropertiesArgsBuilder internal constructor() {
    private var apiConfigurations: Output<List<TelephonyChannelResourceApiConfigurationArgs>>? = null

    private var cognitiveServiceRegion: Output<String>? = null

    private var cognitiveServiceSubscriptionKey: Output<String>? = null

    private var defaultLocale: Output<String>? = null

    private var isEnabled: Output<Boolean>? = null

    private var phoneNumbers: Output<List<TelephonyPhoneNumbersArgs>>? = null

    private var premiumSKU: Output<String>? = null

    /**
     * @param value The list of Telephony api configuration
     */
    @JvmName("dibnhfhbkkykypet")
    public suspend fun apiConfigurations(`value`: Output<List<TelephonyChannelResourceApiConfigurationArgs>>) {
        this.apiConfigurations = value
    }

    @JvmName("vvonylgbiliwaxhd")
    public suspend fun apiConfigurations(vararg values: Output<TelephonyChannelResourceApiConfigurationArgs>) {
        this.apiConfigurations = Output.all(values.asList())
    }

    /**
     * @param values The list of Telephony api configuration
     */
    @JvmName("rouyjkhdiufggmvc")
    public suspend fun apiConfigurations(values: List<Output<TelephonyChannelResourceApiConfigurationArgs>>) {
        this.apiConfigurations = Output.all(values)
    }

    /**
     * @param value The extensionKey2
     */
    @JvmName("khuwwlgchrkgropn")
    public suspend fun cognitiveServiceRegion(`value`: Output<String>) {
        this.cognitiveServiceRegion = value
    }

    /**
     * @param value The extensionKey1
     */
    @JvmName("mphqgofvykidugjy")
    public suspend fun cognitiveServiceSubscriptionKey(`value`: Output<String>) {
        this.cognitiveServiceSubscriptionKey = value
    }

    /**
     * @param value The default locale of the channel
     */
    @JvmName("ahqemfniewivytdq")
    public suspend fun defaultLocale(`value`: Output<String>) {
        this.defaultLocale = value
    }

    /**
     * @param value Whether the channel is enabled
     */
    @JvmName("oaeknfylujhtirrp")
    public suspend fun isEnabled(`value`: Output<Boolean>) {
        this.isEnabled = value
    }

    /**
     * @param value The list of Telephony phone numbers
     */
    @JvmName("wakyoqfvamxfjbpg")
    public suspend fun phoneNumbers(`value`: Output<List<TelephonyPhoneNumbersArgs>>) {
        this.phoneNumbers = value
    }

    @JvmName("fetdrjpegfggxwix")
    public suspend fun phoneNumbers(vararg values: Output<TelephonyPhoneNumbersArgs>) {
        this.phoneNumbers = Output.all(values.asList())
    }

    /**
     * @param values The list of Telephony phone numbers
     */
    @JvmName("kjqtdwghlloyxmti")
    public suspend fun phoneNumbers(values: List<Output<TelephonyPhoneNumbersArgs>>) {
        this.phoneNumbers = Output.all(values)
    }

    /**
     * @param value The premium SKU applied to the channel
     */
    @JvmName("nvtsnvcafoldixha")
    public suspend fun premiumSKU(`value`: Output<String>) {
        this.premiumSKU = value
    }

    /**
     * @param value The list of Telephony api configuration
     */
    @JvmName("fsxnjtnwdhegryir")
    public suspend fun apiConfigurations(`value`: List<TelephonyChannelResourceApiConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiConfigurations = mapped
    }

    /**
     * @param argument The list of Telephony api configuration
     */
    @JvmName("ugqfggednqyfrism")
    public suspend fun apiConfigurations(argument: List<suspend TelephonyChannelResourceApiConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TelephonyChannelResourceApiConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.apiConfigurations = mapped
    }

    /**
     * @param argument The list of Telephony api configuration
     */
    @JvmName("mhchtnhevvnulepj")
    public suspend fun apiConfigurations(vararg argument: suspend TelephonyChannelResourceApiConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            TelephonyChannelResourceApiConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.apiConfigurations = mapped
    }

    /**
     * @param argument The list of Telephony api configuration
     */
    @JvmName("fgwwrywwqtdsowud")
    public suspend fun apiConfigurations(argument: suspend TelephonyChannelResourceApiConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            TelephonyChannelResourceApiConfigurationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.apiConfigurations = mapped
    }

    /**
     * @param values The list of Telephony api configuration
     */
    @JvmName("ajowpevrqffuqcap")
    public suspend fun apiConfigurations(vararg values: TelephonyChannelResourceApiConfigurationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.apiConfigurations = mapped
    }

    /**
     * @param value The extensionKey2
     */
    @JvmName("xhhufdtwlhnogbmw")
    public suspend fun cognitiveServiceRegion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cognitiveServiceRegion = mapped
    }

    /**
     * @param value The extensionKey1
     */
    @JvmName("byymvmlbqoxqksbo")
    public suspend fun cognitiveServiceSubscriptionKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cognitiveServiceSubscriptionKey = mapped
    }

    /**
     * @param value The default locale of the channel
     */
    @JvmName("lptreousgspfoxwm")
    public suspend fun defaultLocale(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultLocale = mapped
    }

    /**
     * @param value Whether the channel is enabled
     */
    @JvmName("qxkmpbobvjkeqapg")
    public suspend fun isEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isEnabled = mapped
    }

    /**
     * @param value The list of Telephony phone numbers
     */
    @JvmName("bwfokvlmlurtvees")
    public suspend fun phoneNumbers(`value`: List<TelephonyPhoneNumbersArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.phoneNumbers = mapped
    }

    /**
     * @param argument The list of Telephony phone numbers
     */
    @JvmName("rqgemxakaaqujyie")
    public suspend fun phoneNumbers(argument: List<suspend TelephonyPhoneNumbersArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TelephonyPhoneNumbersArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.phoneNumbers = mapped
    }

    /**
     * @param argument The list of Telephony phone numbers
     */
    @JvmName("dvnrqewnxrcgrxxa")
    public suspend fun phoneNumbers(vararg argument: suspend TelephonyPhoneNumbersArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            TelephonyPhoneNumbersArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.phoneNumbers = mapped
    }

    /**
     * @param argument The list of Telephony phone numbers
     */
    @JvmName("xdnsrhmnikoqcbjb")
    public suspend fun phoneNumbers(argument: suspend TelephonyPhoneNumbersArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(TelephonyPhoneNumbersArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.phoneNumbers = mapped
    }

    /**
     * @param values The list of Telephony phone numbers
     */
    @JvmName("jcvxfdwqlemybaxr")
    public suspend fun phoneNumbers(vararg values: TelephonyPhoneNumbersArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.phoneNumbers = mapped
    }

    /**
     * @param value The premium SKU applied to the channel
     */
    @JvmName("bkuqsvgwuhuprhnj")
    public suspend fun premiumSKU(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.premiumSKU = mapped
    }

    internal fun build(): TelephonyChannelPropertiesArgs = TelephonyChannelPropertiesArgs(
        apiConfigurations = apiConfigurations,
        cognitiveServiceRegion = cognitiveServiceRegion,
        cognitiveServiceSubscriptionKey = cognitiveServiceSubscriptionKey,
        defaultLocale = defaultLocale,
        isEnabled = isEnabled,
        phoneNumbers = phoneNumbers,
        premiumSKU = premiumSKU,
    )
}
